<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certificate of Participation</title>
    <link rel="stylesheet" href="styles.css">
</head>
<style>
    * {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Arial', sans-serif;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    background-color: #f5f5f5;
}

.certificate {
    width: 900px;
    padding: 40px;
    background-color: #fff;
    border: 5px solid #000;
    border-radius: 10px;
    position: relative;
    text-align: center;
}

.certificate-border {
    padding: 20px;
    border: 1px solid #000;
    border-radius: 10px;
    position: relative;
}

.title {
    font-size: 36px;
    font-weight: bold;
    text-transform: uppercase;
    margin-bottom: 20px;
}

.description {
    font-size: 18px;
    margin-bottom: 10px;
}

.recipient {
    font-size: 30px;
    font-weight: bold;
    margin: 20px 0;
    font-family: 'Cursive', sans-serif;
}

.date {
    font-size: 18px;
    margin: 20px 0;
}

.signature-section {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-top: 40px;
}

.signature {
    text-align: center;
}

.signature img {
    width: 200px;
    height: auto;
}

.seal img {
    width: 100px;
    height: auto;
}

</style>
<body>
    <div class="certificate">
        <div class="certificate-border">
            <h1 class="title">Certificate of Participation</h1>
            <p class="description">This certificate is awarded to</p>
            <h2 class="recipient">{{$name}}</h2>
            <p class="description">
                in recognition of your participation in the Leadership Skills Development 
                Training Program held in Sweden in June, 2018
            </p>
            <p class="date">Awarded on the 27th day of June, 2018</p>

            <div class="signature-section">
                <div class="signature">
                    <img src="signature.png" alt="Instructor Signature">
                    <p>Instructor</p>
                </div>
                <div class="seal">
                    <img src="{{ asset('assets/images/seal.png') }}" alt="Red Seal">
                </div>
            </div>
        </div>
    </div>
</body>
</html>
