<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Clouddreams|Form</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>" type="image/x-icon" />
    <!-- Bootstrap -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/Bootstrap/bootstrap.min.css')); ?>" />

    <!-- Font Awesome -->
    <link
        rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" />

    <!-- Custom Style -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>" />

    <!-- Animation -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/animation.css')); ?>" />

    <!-- Responsive -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/responsive.css')); ?>" />
</head>
<style>
    /* Style for required fields */
    .required {
        color: red;
        font-weight: bold;
    }

    /* Style for error messages */
    .error {
        color: red;
        font-size: 0.875em;
        /* Slightly smaller text for error messages */
        margin-top: 0.25em;
        /* Space between the input and error message */
    }
  
</style>

<body>
    <main class="overflow-hidden py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <!-- <div class="mainHeadingArea animateTop">
                        <h1 class="heading1">christmas</h1>
                        <h2 class="heading2">
                            <img src="<?php echo e(asset('assets/images/stars.png')); ?>" alt="Star" />
                            party
                            <img src="<?php echo e(asset('assets/images/stars.png')); ?>" alt="Star" />
                        </h2>
                        <h3 class="heading3">
                            <div class="line"></div>
                            <span>JOIN US FOR A</span> JOLLY GOOD TIME!
                            <div class="line"></div>
                        </h3>
                    </div> -->
                    <!-- <div class="row align-items-center mt-4">
                        <div class="col-md-8">
                            <div class="date">
                                <div class="inner animateleft">
                                    monday
                                    <h5>dec 25<sup>th</sup></h5>
                                    <div class="address">YOUR COZY HOUSE ADDRESS - SPAIN</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <ul class="item-list">
                                <li><span></span>food</li>
                                <li><span></span>beer</li>
                                <li><span></span>art</li>
                                <li><span></span>music</li>
                                <li><span></span>gifts</li>
                            </ul>
                        </div>
                    </div> -->
                </div>
                <div class="col-md-6">
                    <form id="certificate-form" action="<?php echo e(route('certificate.generate')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <article>
                            <h2>Grab your certificates</h2>
                            <p>Honoring Your Milestones, One Certificate at a Time.</p>
                        </article>
                        <fieldset>
                            <div class="inputField">
                                <input type="text" name="name" value="<?php echo e(old('name')); ?>" />
                                <label>Full Name<span class="required">*</span></label>
                                <div class="error" id="error-name"></div>
                            </div>
                            <div class="inputField">
                                <input type="text" name="phone" value="<?php echo e(old('phone')); ?>" />
                                <label>Phone Number<span class="required">*</span></label>
                                <div class="error" id="error-phone"></div>
                            </div>
                            <div class="inputField">
                                <input type="email" name="email" value="<?php echo e(old('email')); ?>" />
                                <label>Email<span class="required">*</span></label>
                                <div class="error" id="error-email"></div>
                            </div>
                            <div class="inputField">
                                <input type="text" name="department" value="<?php echo e(old('department')); ?>" />
                                <label>Department<span class="required">*</span></label>
                                <div class="error" id="error-department"></div>
                            </div>
                            <div class="inputField">
                                <input type="text" name="college_name" value="<?php echo e(old('college_name')); ?>" />
                                <label>College Name<span class="required">*</span></label>
                                <div class="error" id="error-college_name"></div>
                            </div>
                            <button type="submit">
                                Crab it<i class="fa-solid fa-right-long"></i>
                            </button>
                        </fieldset>
                    </form>



                </div>
            </div>
        </div>
    </main>

    <!-- Bootstrap JS -->
    <script src="<?php echo e(asset('assets/js/Bootstrap/bootstrap.min.js')); ?>"></script>

    <!-- jQuery -->
    <script src="<?php echo e(asset('assets/js/jQuery/jquery-3.7.1.min.js')); ?>"></script>

    <!-- Custom JS -->
    <script src="<?php echo e(asset('assets/js/custom.js')); ?>"></script>
    <script>
        document.getElementById('certificate-form').addEventListener('submit', function(event) {
            console.log('Form submission initiated');
            event.preventDefault(); // Prevent default form submission

            var form = this;
            var formData = new FormData(form);
            var csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

            // Clear previous error messages
            document.getElementById('error-name').textContent = '';
            document.getElementById('error-phone').textContent = '';
            document.getElementById('error-email').textContent = '';
            document.getElementById('error-department').textContent = '';
            document.getElementById('error-college_name').textContent = '';

            fetch(form.action, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': csrfToken
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        return response.json().then(errorData => {
                            // Handle validation errors
                            document.getElementById('error-name').textContent = errorData.errors.name ? errorData.errors.name[0] : '';
                            document.getElementById('error-phone').textContent = errorData.errors.phone ? errorData.errors.phone[0] : '';
                            document.getElementById('error-email').textContent = errorData.errors.email ? errorData.errors.email[0] : '';
                            document.getElementById('error-department').textContent = errorData.errors.department ? errorData.errors.department[0] : '';
                            document.getElementById('error-college_name').textContent = errorData.errors.college_name ? errorData.errors.college_name[0] : '';
                        });
                    } else {
                        return response.blob(); // Download PDF
                    }
                })
                .then(blob => {
                    if (blob) {
                        var url = window.URL.createObjectURL(blob);
                        var a = document.createElement('a');
                        a.href = url;
                        a.download = 'certificate.pdf';
                        document.body.appendChild(a);
                        a.click();
                        a.remove();
                        window.URL.revokeObjectURL(url);

                        // Reset the form fields
                        form.reset();
                    }
                })
                .catch(error => console.error('Error:', error));
        });
    </script>


</body>

</html><?php /**PATH /home/icloudcsin/public_html/Clouddreams-form/resources/views/welcome.blade.php ENDPATH**/ ?>