import React, { useEffect, useMemo, Suspense } from "react";
import AOS from "aos";
import "aos/dist/aos.css";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import "./App.css";
import "./Responsive.css";


import Loader from "./Components/Loader";

// Lazy load all components including Navbar and Footer
const Navbar = React.lazy(() => import("./Includes/Navbar"));
const Footer = React.lazy(() => import("./Includes/Footer"));
const HomePage = React.lazy(() => import("./Pages/HomePage"));
const AboutPage = React.lazy(() => import("./Pages/AboutPage"));
const CodissiainfoPage = React.lazy(() => import("./Pages/CodissiainfoPage"));
const ExhibitorsPage = React.lazy(() => import("./Pages/ExhibitorsPage"));
const VisitorsPage = React.lazy(() => import("./Pages/VisitorsPage"));
const GalleryPage = React.lazy(() => import("./Pages/GalleryPage"));
const ContactPage = React.lazy(() => import("./Pages/ContactPage"));
const TermsconditionsPage = React.lazy(() => import("./Pages/TermsconditionsPage"));
const PrivacyPage = React.lazy(() => import("./Pages/PrivacyPage"));
const NotFoundPage = React.lazy(() => import("./Pages/NotFoundPage"));
const BackToTop = React.lazy(() => import("./Includes/backtotop"));

function AppContent() {
  // Initialize AOS once
  useEffect(() => {
    AOS.init({
      duration: 800,
      once: true,
      initClassName: 'aos-init',
      easing: 'ease-out-quad'
    });

    return () => {
      AOS.refresh();
    };
  }, []);

  // Memoize routes to prevent unnecessary re-renders
  const appRoutes = useMemo(() => (
    <Routes>
      <Route path="/" element={
        <Suspense fallback={<Loader />}>
          <HomePage />
        </Suspense>
      } />
      <Route path="/about" element={
        <Suspense fallback={<Loader />}>
          <AboutPage />
        </Suspense>
      } />
      <Route path="/codissiainfo" element={
        <Suspense fallback={<Loader />}>
          <CodissiainfoPage />
        </Suspense>
      } />
      <Route path="/exhibitors" element={
        <Suspense fallback={<Loader />}>
          <ExhibitorsPage />
        </Suspense>
      } />
      <Route path="/visitors" element={
        <Suspense fallback={<Loader />}>
          <VisitorsPage />
        </Suspense>
      } />
      <Route path="/gallery" element={
        <Suspense fallback={<Loader />}>
          <GalleryPage />
        </Suspense>
      } />
      <Route path="/contact" element={
        <Suspense fallback={<Loader />}>
          <ContactPage />
        </Suspense>
      } />
      <Route path="/termsconditions" element={
        <Suspense fallback={<Loader />}>
          <TermsconditionsPage />
        </Suspense>
      } />
      <Route path="/privacypolicy" element={
        <Suspense fallback={<Loader />}>
          <PrivacyPage />
        </Suspense>
      } />
      <Route path="*" element={
        <Suspense fallback={<Loader />}>
          <NotFoundPage />
        </Suspense>
      } />
    </Routes>
  ), []);

  return (
    <>
      <Suspense fallback={null}>
        <Navbar />
      </Suspense>
      {appRoutes}
      <Suspense fallback={null}>
        <Footer />
      </Suspense>
      <Suspense fallback={null}>
        <BackToTop />
      </Suspense>
    </>
  );
}

function App() {
  return (
    <BrowserRouter>
      <Suspense fallback={<Loader fullPage={true} />}>
        <AppContent />
      </Suspense>
    </BrowserRouter>
  );
}

export default React.memo(App);