import React, { useState } from "react";
import { Container, Row, Col } from "react-bootstrap";
import { motion } from "framer-motion";
import CoreValues from "./Corevalues";
import aboutbg from "../../assets/about/about-bg.png";
import information from "../../assets/about/information.gif";
import MissionVision from "./MissionVision";
import mission1 from "../../assets/about/organization.png";
import vision1 from "../../assets/about/visionmission/vision.jpg";
import Sidebar from "./Sidebar";

const Aboutus = () => {
  const [activeTab, setActiveTab] = useState("mission");

  // Dynamically update the image based on activeTab
  const selectedImage = activeTab === "mission" ? mission1 : vision1;

  return (
    <section className="build-intec-banner">
      <div>
        <div className="subbaner-buildintec">
          <div className="text-center breadcrumbs">
            <h4>Build Intec </h4>
          </div>
        </div>
      </div>

      <Container className="py-5">
        <Row>
          <Col lg={12} className="text-center mb-4">
            <motion.h4
              initial={{ opacity: 0, y: -50 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 1 }}
            >
              WELCOME TO BUILD INTEC 2026
            </motion.h4>
            <motion.p
              className="lead gradient-text"
              initial={{ opacity: 0, y: -30 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 1, delay: 0.3 }}
            >
              India's Prime Building And Construction Trade Fair
            </motion.p>
          </Col>
          <Col lg={6}>
            <motion.div
              className="banner-image mb-4"
              initial={{ opacity: 0 }}
              animate={{ opacity: 1 }}
              transition={{ duration: 1, delay: 0.5 }}
            >
              {/* Change image dynamically based on activeTab */}
              <img
                src={selectedImage}
                alt="Build Intec"
                className="img-fluid shadow-lg"
              />
              <div>
                <img className="img-fluid about-bg-left" src={aboutbg} alt="" />
              </div>
              <div>
                <img
                  className="img-fluid about-bg-right"
                  src={aboutbg}
                  alt=""
                />
              </div>
            </motion.div>
          </Col>
          <Col lg={6} className="about-us-info">
            <motion.div
              className="banner-image"
              initial={{ opacity: 0 }}
              animate={{ opacity: 1 }}
              transition={{ duration: 1, delay: 0.5 }}
            >
              <motion.h4
                className=""
                initial={{ opacity: 0, y: -50 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 1 }}
              >
                About Expo
              </motion.h4>
              <p>
                The expo stands as one of the largest in the region, attracting
                the most relevant visitors and offering an excellent platform
                for business networking. It brings together engineers, project
                developers, government officials, and representatives from smart
                city missions, fostering valuable connections. The event enjoys
                strong representation from all segments of the construction
                industry, with the support of various trade associations.
              </p>
              <p>
                It draws a diverse audience, including architects, builders,
                civil engineers, retailers, and individuals, creating a dynamic
                environment for industry professionals. The expo's increasing
                popularity continues to attract more visitors, benefiting
                exhibitors and receiving encouraging feedback from those who
                participated in previous editions.
              </p>
            </motion.div>
          </Col>
          <Col lg={12} className="mt-5">
            <Col lg={12} className="about-us-info">
              <motion.h4
                className=""
                initial={{ opacity: 0, y: -50 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 1 }}
              >
                Strategic Location
              </motion.h4>
              <motion.p
                initial={{ opacity: 0, y: -30 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 1, delay: 0.3 }}
              >
                <span>
                  {" "}
                  Coimbatore, an industrial hub with investor-friendly culture,
                  is the perfect location for BUILD INTEC 2026.{" "}
                </span>
              </motion.p>
              <div>
                <div className="row">
                  <div className="col-lg-6 mb-3">
                    <motion.span
                      className="lead"
                      initial={{ opacity: 0, y: -30 }}
                      animate={{ opacity: 1, y: 0 }}
                      transition={{ duration: 1, delay: 0.3 }}
                    >
                      <span>
                        <img width="20px" src={information} alt="" srcset="" />
                      </span>{" "}
                      Coimbatore witnesses the massive congregation of world's
                      construction industries' best brains and best hands at a
                      single place - CODISSIA's BUILD INTEC 2026 exhibition
                      venue. The entire industrial world is going to be unveiled
                      here with multitude of possibilities, displaying dreams,
                      trading future and creating associations.
                    </motion.span>
                  </div>
                  <div className="col-lg-6 ">
                    <motion.span
                      className="lead"
                      initial={{ opacity: 0, y: -30 }}
                      animate={{ opacity: 1, y: 0 }}
                      transition={{ duration: 1, delay: 0.3 }}
                    >
                      <span>
                        <img width="20px" src={information} alt="" srcset="" />
                      </span>{" "}
                      Coimbatore, an industrial hub with investor-friendly
                      culture and geography, has been the destination of many
                      international business ventures since last few years. Now,
                      this area attracts investments in segments like Housing
                      Sector, Malls, Star hotels, Textile, Engineering, IT
                      sector and Infrastructure.
                    </motion.span>
                  </div>
                </div>
              </div>
            </Col>
          </Col>
        </Row>
      </Container>
      <Sidebar />
      <CoreValues />
    </section>
  );
};

export default React.memo(Aboutus) ;
