import React from "react";
import { motion } from "framer-motion";
import { Viewer, Worker } from "@react-pdf-viewer/core";
import { defaultLayoutPlugin } from "@react-pdf-viewer/default-layout";
import "@react-pdf-viewer/core/lib/styles/index.css";
import "@react-pdf-viewer/default-layout/lib/styles/index.css";

import brochure from "../../assets/exhibitors/BI 2025 - Brochure.pdf";
import sponsorship from "../../assets/exhibitors/BI 2025 - Sponsorship Benefits.pdf";

const Certificate = () => {
  // Initialize default layout plugin
  const defaultLayoutPluginInstance = defaultLayoutPlugin();

  return (
    <div>
      <div className="container mb-5">
        <div className="text-center">
          <motion.h2
            className="fw-bold mb-3"
            initial={{ y: -20, opacity: 0 }}
            animate={{ y: 0, opacity: 1 }}
            transition={{ duration: 0.5 }}
          >
            View Our Documents
          </motion.h2>
          <motion.p
            className="text-muted w-75 mx-auto"
            initial={{ y: -20, opacity: 0 }}
            animate={{ y: 0, opacity: 1 }}
            transition={{ duration: 0.5, delay: 0.2 }}
          >
            Our documents reflect our commitment to transparency and excellence,
            offering insights into our policies, guidelines, and strategies.
          </motion.p>
        </div>
      </div>

      <div className="container mb-5">
        <div className="row">
          {/* First PDF */}
          <div className="col-lg-6 mb-4">
            <div className="text-center mb-3">
              <h6> <strong>Brochure </strong> </h6>
            </div>
            <motion.div
              initial={{ opacity: 0, y: -30 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 1, delay: 0.3 }}
              className="d-flex flex-column align-items-center"
            >
              <Worker workerUrl="https://unpkg.com/pdfjs-dist@3.11.174/build/pdf.worker.js">
                <div
                  style={{
                    border: "1px solid #ccc",
                    width: "100%",
                    height: "800px",
                  }}
                >
                  <Viewer
                    fileUrl={brochure}
                    plugins={[defaultLayoutPluginInstance]}
                  />
                </div>
              </Worker>
            </motion.div>
          </div>

          {/* Second PDF */}
          <div className="col-lg-6">
          <div className="text-center mb-3">
              <h6> <strong>Exhibition Services Categories </strong> </h6>
            </div>
            <motion.div
              initial={{ opacity: 0, y: -30 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 1, delay: 0.3 }}
              className="d-flex flex-column align-items-center"
            >
              <Worker workerUrl="https://unpkg.com/pdfjs-dist@3.11.174/build/pdf.worker.js">
                <div
                  style={{
                    border: "1px solid #ccc",
                    width: "100%",
                    height: "800px",
                  }}
                >
                  <Viewer
                    fileUrl={sponsorship}
                    plugins={[defaultLayoutPluginInstance]}
                  />
                </div>
              </Worker>
             
            </motion.div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default React.memo(Certificate);
