import React from "react";
import { Container, Row, Col } from "react-bootstrap";
import { motion } from "framer-motion";

import { FaCar, FaPlane, FaTrain, FaRoad, FaBuilding, FaWifi } from "react-icons/fa";
import { IoArrowRedoOutline } from "react-icons/io5";

export default function CodissiaInfo() {
  return (
    <div>
      <div>
        <div className="subbaner-codissia">
          <div className="text-center breadcrumbs">
            <h4>Codissia Info</h4>
          
          </div>
        </div>
      </div>
      
      <section className="build-intec-banner">
        <Container className="py-5">
          <Row className="align-items-center ">
            <Col lg={12} className="text-center mb-3">
              <motion.h4
            
                initial={{ opacity: 0, y: -50 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 1 }}
              >
                Coimbatore District Small Industries Association (CODISSIA)
              </motion.h4>
              <motion.p
                className=" gradient-text"
                initial={{ opacity: 0, y: -30 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 1, delay: 0.3 }}
              >
              
                The Coimbatore District Small Industries Association popularly
                known as CODISSIA, was established in the year 1969. It is a
                Non-Profit, ISO 9001-2015 certified, one of the largest Business
                Membership Organisation for Micro, Small and Medium Enterprises
                in India. It has a membership of more than 6600 MSME’s from
                different segments. CODISSIA works for Industrial development,
                economic growth and prosperity of Coimbatore region. The
                Association has made significant contribution towards building a
                strong and stable industrial belt in this region and created
                awareness among entrepreneurs.
              </motion.p>
            </Col>
          </Row>
          <Row className="buildintec-list">
            <Col lg={6} className="mb-3" >
              <ul>
                <li  className="mb-3" >
                   <IoArrowRedoOutline className="movingarrow"/>
                  CODISSIA charter affirms to build up healthy powerful and
                  quality SMEs through sustained efforts, firm commitment and a
                  system to review continuing suitability of policies and to
                  analyze new ideas for continuous improvement
                </li>
                <li  className="mb-3" >
                <IoArrowRedoOutline className="movingarrow"/>
                  The Association serves for the growth and prosperity of
                  industries and it has made a significant contribution towards
                  building a strong and stable Industrial City – Coimbatore
                </li>
                <li  className="mb-3" >
                <IoArrowRedoOutline className="movingarrow"/>
                  The Association besides functioning as a grievance redresseal
                  unit, also functions as a development oriented Association
                  conducting series of Seminars/ Training Programmers/ Study
                  Tours/ Exhibitions/ Industrial Trade Fairs/ Industrial visits
                  etc. so as to develop and create awareness among industrial
                  entrepreneurs
                </li>
              </ul>
            </Col>
            <Col lg={6} className="mb-3" >
              {/* 2 */}
              <ul>
                <li  className="mb-3" >
                <IoArrowRedoOutline className="movingarrow"/>
                  CODISSIA has dedicated itself to the cause of small-scale
                  industries and has made its mark at the District/ State and
                  National levels by its selfless service to SSI’s in a variety
                  of ways The Association renders guidance and help to the new
                  entrepreneurs in the identification of products/ preparation
                  of project reports and getting financial assistance from
                  banks, licenses from various departments, etc.{" "}
                </li>
                <li  className="mb-3" >
                <IoArrowRedoOutline className="movingarrow"/>
                  It has set up its own trade fair center from resource
                  mobilisation to conduct world class industrial fairs. These
                  Trade Fairs provide a platform for Small Industries to come
                  internationally and earn valuable foreign exchange
                </li>
                <li  className="mb-3" >
                <IoArrowRedoOutline className="movingarrow"/>
                  CODISSIA is the only District Level Association in the whole
                  of India to have signed a Memorandum of Understanding with
                  (VDMA) Plant and Machinery Manufacturers Association/ Bavarian
                  Section of West Germany to work jointly to assist the members
                  in identifying new technologies/ promote joint ventures,
                  Technology transfers and to send trade delegation etc. to
                  Foreign Countries like Germany Technology transfer through
                  ZDH, Germany TUV Rheinland
                </li>
              </ul>
            </Col>
            <Col lg={6} className="mb-3" >
              {/* 3 */}
              <ul>
                <li>
                <IoArrowRedoOutline className="movingarrow"/>
                  Established in 1999, a significant forum in Coimbatore, the
                  CODISSIA Trade Fair Complex is one of India’s Largest trade
                  fair complex and a recognized venue in the industrial and
                  exhibition industry of Tamil Nadu, India. Well-known amongst
                  the regional exhibiting companies for hosting some of the most
                  notable events and seminars in South India, it has been the
                  main inspiration for all upcoming exhibition venues in the
                  country. It is certified as a World Record holder in the Limca
                  Book of Records and enjoys the unique distinction of being
                  Asia’s largest pillar free hall. Constructed in a record time
                  of 155 days, it was set up with the aim of providing
                  state-of-the-art infrastructural facilities for conducting
                  trade fairs.
                </li>
              </ul>
            </Col>
            <Col lg={6} className="mb-3" >
              {/* 4 */}
              <ul>
                <li>
                <IoArrowRedoOutline className="movingarrow"/>
                  The exhibition building spans on an area in excess of 2,00,000
                  sq ft and has been equipped with ultra-modern features. It
                  also makes it available for its exhibitors an outdoor space
                  for hosting parties, open air events, and many more. It
                  consists of both air-conditioned and non air-conditioned
                  exhibition halls for conducting indoor events, seminars and
                  meetings in addition to trade fairs. Purposely built keeping
                  in mind the highest standards, the CODISSIA Trade Fair Complex
                  provides facilities such as parking space, food court and
                  communication facilities. On par with the Pragati Maidan, New
                  Delhi, it is the first of its kind in South India to host
                  trade fairs on an international level. Spread over an expanse
                  of 40 acres, the complex houses every conceivable facility
                  demanded by a trade fair.
                </li>
              </ul>
            </Col>
            <Col lg={6} className="mb-3" >
              {/* 5 */}

              <ul>
                <div className="d-flex">
                <p  >Salient Features of CODISSIA Trade Fair Complex</p>
                </div>
           
                <li>
                  <FaPlane /> 2 Kms away from the Airport
                </li>
                <li>
                  <FaTrain /> 6 Kms away from the Railway Station
                </li>
                <li>
                  <FaRoad /> 1 Km away from NH-47
                </li>
                <li>
                  <FaBuilding /> Systematic and excellent stall layout for high
                  visibility
                </li>
                <li>
                  <FaBuilding /> Conference halls and demonstration facilities
                  for special promotional activities
                </li>
                <li>
                  <FaBuilding /> Covered column-free exhibition space of 20,000
                  sq.mts
                </li>
                <li>
                  <FaBuilding /> Roof height of 10.65 mt for easy handling of
                  heavy machineries
                </li>
                <li>
                  <FaBuilding /> Heavy-duty flooring
                </li>
                <li>
                  <FaWifi /> Availability of power, water, and pneumatic air
                </li>
                <li>
                  <FaCar /> Ample parking space for 2,000 cars and 10,000
                  two-wheelers
                </li>
                <li>
                  <FaWifi /> Wi-Fi enabled 24-hours communication centre
                </li>
              </ul>
            </Col>
          </Row>
        </Container>
      </section>
    </div>
  );
}
