import React from "react";
import { motion } from "framer-motion";
import Collaboration from "../../assets/about/collabration.gif";
import Transparency from "../../assets/about/transperancy.gif";
import Trust from "../../assets/about/trust.gif";
import Integrity from "../../assets/about/integrity.gif";

const values = [
  {
    title: "Collaboration",
    description:
      "Collaboration is the process of two or more people or organizations working together to complete a task or achieve a goal.",
    icon: Collaboration,
  },
  {
    title: "Transparency",
    description:
      "Transparency, as used in science, is operating in such a way that it is easy for others to see what actions are performed.",
    icon: Transparency,
  },
  {
    title: "Trust",
    description:
      "Trust will help us foster a positive and productive environment that delivers value to our users and customers.",
    icon: Trust,
  },
  {
    title: "Integrity",
    description:
      "Integrity is the practice of being honest and showing a consistent and uncompromising adherence to strong moral and ethical principles.",
    icon: Integrity,
  },
];

const CoreValues = () => {
  return (
    <motion.div
      className="container mb-5 mt-5 text-center"
      initial={{ opacity: 0 }}
      animate={{ opacity: 1 }}
      transition={{ duration: 1 }}
    >
      <motion.h2 className="fw-bold mb-3" initial={{ y: -20, opacity: 0 }} animate={{ y: 0, opacity: 1 }} transition={{ duration: 0.5 }}>
        Our Core Values
      </motion.h2>
      <motion.p className="text-muted w-75 mx-auto" initial={{ y: -20, opacity: 0 }} animate={{ y: 0, opacity: 1 }} transition={{ duration: 0.5, delay: 0.2 }}>
        Our values shape the culture of our organization and define the character of our company.
      </motion.p>

      <div className="row mt-4 g-4">
        {values.map((value, index) => (
          <motion.div
            key={index}
            className="col-md-6"
            initial={{ opacity: 0, y: 40 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: index * 0.2 }}
          >
            <motion.div
              className="p-4 position-relative corevalues-main"
              whileHover={{ scale: 1.05, boxShadow: "0px 10px 20px rgba(0, 0, 0, 0.2)" }}
              transition={{ duration: 0.3 }}
            >
              <motion.img
                className="core-values-img"
                src={value.icon}
                alt={value.title}
                initial={{ scale: 0.8, opacity: 0 }}
                animate={{ scale: 1, opacity: 1 }}
                transition={{ duration: 0.5, delay: index * 0.3 }}
                whileHover={{ scale: 1.1 }}
              />
              <motion.h4 className="mt-4">{value.title}</motion.h4>
              <motion.p className="text-muted">{value.description}</motion.p>
            </motion.div>
          </motion.div>
        ))}
      </div>
    </motion.div>
  );
};

export default React.memo(CoreValues);
