import React from "react";
import { motion, AnimatePresence } from "framer-motion";
import mission from "../../assets/about/mission.png";
import vision from "../../assets/about/vision.png";

const MissionVision = ({ activeTab, setActiveTab }) => {
  const tabs = [
    { id: "mission", label: "Mission", vector: mission },
    { id: "vision", label: "Vision", vector: vision },
  ];

  const content = {
    mission:
      "To establish BUILD INTEC as a global platform that fosters innovation, collaboration, and excellence in the construction industry, empowering businesses with cutting-edge technology, sustainable solutions, and growth opportunities. It aims to drive transformative advancements that shape the future of smart and resilient infrastructure.",
    vision:
      "The event aims to bring together industry leaders, experts, and innovators to showcase advancements in construction technology and infrastructure. It seeks to create an ecosystem that fosters knowledge exchange, networking, and business expansion among global and local stakeholders. Additionally, it emphasizes the importance of sustainable.",
  };

  return (
    <div className="flex flex-col items-center justify-center bg-gray-100 p-6">
      {/* Tab Links */}
      <div className="flex space-x-4 bg-white p-2 rounded-xl shadow-md">
        {tabs.map((tab) => (
          <motion.button
            key={tab.id}
            onClick={() => setActiveTab(tab.id)}
            className={`px-6 py-2 font-medium rounded-lg relative transition-colors unique-tab ${
              activeTab === tab.id ? `active-tab active-${tab.id}` : `inactive-tab`
            }`}
            initial={{ opacity: 0.5 }}
            animate={{ opacity: 1 }}
            whileHover={{ scale: 1.1 }}
          >
            {tab.label}
          </motion.button>
        ))}
      </div>

      {/* Content */}
      <div className="mt-6 p-6 bg-white shadow-md rounded-xl w-full max-w-lg flex flex-col items-center">
        <AnimatePresence mode="wait">
          <motion.p
            key={activeTab}
            initial={{ opacity: 0, y: 10 }}
            animate={{ opacity: 1, y: 0 }}
            exit={{ opacity: 0, y: -10 }}
            transition={{ duration: 0.5 }}
            className="text-lg text-gray-800 text-justify"
          >
            {content[activeTab]}
          </motion.p>
        </AnimatePresence>
        <div className="d-flex justify-content-end">
          <motion.img
            key={activeTab}
            src={tabs.find((tab) => tab.id === activeTab)?.vector}
            alt={activeTab}
            className="mt-4 w-40 h-40 object-contain img-fluid"
            initial={{ opacity: 0, scale: 0.8 }}
            animate={{ opacity: 1, scale: 1 }}
            exit={{ opacity: 0, scale: 0.8 }}
            transition={{ duration: 0.5 }}
          />
        </div>
      </div>
    </div>
  );
};


export default React.memo(MissionVision);