import React, { useState } from "react";
import { motion } from "framer-motion";
import { ToastContainer, toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import location from "../../assets/contact/location.gif";
import contact from "../../assets/contact/contact.gif";
import mail from "../../assets/contact/mail.gif";
import apiService from "../../services/apiservices";

const ContactSection = () => {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    mobile: "",
    country: "",
    company: "",
    requirement: "",
  });

  const [errors, setErrors] = useState({});

  const handleChange = (e) => {
    setFormData({
      ...formData,
      [e.target.id]: e.target.value,
    });
  };

  const handleSubmit = async (e) => {
    e.preventDefault();

    try {
      await apiService.post("submit-enquiry", formData);

      setErrors({});
      toast.success("Enquiry submitted successfully!", {
        position: "top-right",
        autoClose: 3000,
        hideProgressBar: false,
        closeOnClick: true,
        pauseOnHover: true,
        draggable: true,
        progress: undefined,
        theme: "light",
      });

      setFormData({
        name: "",
        email: "",
        mobile: "",
        country: "",
        company: "",
        requirement: "",
      });
    } catch (error) {
      console.error("Submission Error:", error);

      if (error.response?.data?.errors) {
        setErrors(error.response.data.errors);
      } else if (error.response?.data?.message) {
        toast.error(error.response.data.message, {
          position: "top-right",
          autoClose: 3000,
          hideProgressBar: false,
          closeOnClick: true,
          pauseOnHover: true,
          draggable: true,
          progress: undefined,
          theme: "light",
        });
      } else {
        toast.error("An unexpected error occurred. Please try again later.", {
          position: "top-right",
          autoClose: 3000,
          hideProgressBar: false,
          closeOnClick: true,
          pauseOnHover: true,
          draggable: true,
          progress: undefined,
          theme: "light",
        });
      }
    }
  };

  return (
    <div>
      <div className="subbaner-contact">
        <div className="text-center breadcrumbs">
          <h4>Contact</h4>
        </div>
      </div>
      <div></div>
      <div className="container py-5">
        <div className="row">
          <div className=" mb-4 col-lg-4" data-aos="zoom-in">
            <div className=" contact-main-1 text-center ">
              <div className="contact-info">
                <div>
                  <span>
                    <img
                      className="contact-icon"
                      src={location}
                      alt=""
                      srcset=""
                    />
                  </span>
                  <h5>Location</h5>
                </div>

                <p>
                  <a href="https://maps.app.goo.gl/6cPXSreqZ9Be25Gx5">
                    <strong>CODISSIA TRADE FAIR COMPLEX</strong>
                    <br />
                    G.V. Fair Grounds, Avinashi Road, Coimbatore – 641 014,
                    Tamil Nadu, INDIA
                  </a>
                </p>
              </div>
            </div>
          </div>

          {/* Contact Info Column */}
          <div className="mb-4 col-lg-4" data-aos="zoom-in">
            <div className=" contact-main-2 text-center">
              <div className="contact-info">
                <span>
                  <img
                    className="contact-icon"
                    src={contact}
                    alt=""
                    srcset=""
                  />
                </span>
                <h5>Contact Info</h5>
                <p>
                  <strong>Phone:</strong>{" "}
                  <a href="tel:+917502722000">+91 75027 22000</a>
                </p>
                
              </div>
            </div>
          </div>

          {/* Mail Info Column */}
          <div className="mb-4 col-lg-4" data-aos="zoom-in">
            <div className=" contact-main-3 text-center">
              <div className="contact-info">
                <span>
                  <img className="contact-icon" src={mail} alt="" srcset="" />
                </span>
                <h5>Mail Info</h5>
                <p>
                  <strong>Email:</strong>{" "}
                  <a href="mailto:buildintec@codissia.com">
                    buildintec@codissia.com
                  </a>
                </p>
              </div>
            </div>
          </div>

          <div className="col-12" data-aos="zoom-in">
            <motion.div
              initial={{ opacity: 0, x: 50 }}
              animate={{ opacity: 1, x: 0 }}
              transition={{ duration: 0.5 }}
            >
              <iframe
                src="https://www.google.com/maps/embed?pb=!1m24!1m8!1m3!1d17663.010731206763!2d77.033076!3d11.034983!3m2!1i1024!2i768!4f13.1!4m13!3e0!4m5!1s0x3ba857bc9b5ea9af%3A0x317ea10df48c4678!2sCoimbatore%20International%20Airport%2C%20Airport%20Road%2C%20Peelamedu%20-%20Pudur%20Main%20Rd%2C%20Coimbatore%2C%20Tamil%20Nadu%20641014%2C%20India!3m2!1d11.030432399999999!2d77.03909279999999!4m5!1s0x3ba8579534789f3d%3A0xd5e4b911e9f43e4e!2sCodissia%20Trade%20Fair%20Complex%20Rd%2C%20Coimbatore%2C%20Tamil%20Nadu%20641014%2C%20India!3m2!1d11.0397185!2d77.0321214!5e1!3m2!1sen!2sus!4v1739793470618!5m2!1sen!2sus"
                width="100%"
                height="300px"
                style={{
                  border: 0,

                  marginBottom: "15px",
                }}
                allowFullScreen
                loading="lazy"
              ></iframe>
            </motion.div>
          </div>
        </div>

        <div className="row mt-3">
          {/* Contact Form */}
          <div className="col-lg-2"></div>
          <div className="col-md-8">
            <motion.div
              initial={{ opacity: 0, x: -50 }}
              animate={{ opacity: 1, x: 0 }}
              transition={{ duration: 0.5 }}
            >
              <div class="text-center mb-3 contact-timing">
                <h4>Get In Touch!!</h4>
              </div>

              <form className="border p-4" onSubmit={handleSubmit}>
                <div className="row">
                  <div className="col-lg-6">
                    <div className="form-floating mb-3">
                      <input
                        type="text"
                        className="form-control no-border-radius"
                        id="name"
                        placeholder="Name"
                        value={formData.name}
                        onChange={handleChange}
                      />
                      <label htmlFor="name">Name</label>
                      {errors.name && (
                        <span className="text-danger">{errors.name}</span>
                      )}
                    </div>
                  </div>
                  <div className="col-lg-6">
                    <div className="form-floating mb-3">
                      <input
                        type="email"
                        className="form-control no-border-radius"
                        id="email"
                        placeholder="Email Address"
                        value={formData.email}
                        onChange={handleChange}
                      />
                      <label htmlFor="email">Email Address</label>
                      {errors.email && (
                        <span className="text-danger">{errors.email}</span>
                      )}
                    </div>
                  </div>
                </div>

                <div className="row">
                  <div className="col-lg-6">
                    <div className="form-floating mb-3">
                      <input
                        type="tel"
                        className="form-control no-border-radius"
                        id="mobile"
                        placeholder="Phone Number"
                        value={formData.mobile}
                        onChange={handleChange}
                      />
                      <label htmlFor="phone">Phone Number</label>
                      {errors.mobile && (
                        <span className="text-danger">{errors.mobile}</span>
                      )}
                    </div>
                  </div>
                  <div className="col-lg-6">
                    <div className="form-floating mb-3">
                      <input
                        type="text"
                        className="form-control no-border-radius"
                        id="country"
                        placeholder="Country"
                        value={formData.country}
                        onChange={handleChange}
                      />
                      <label htmlFor="country">Country</label>
                      {errors.country && (
                        <span className="text-danger">{errors.country}</span>
                      )}
                    </div>
                  </div>
                </div>

                <div className="form-floating mb-3">
                  <input
                    type="text"
                    className="form-control no-border-radius"
                    id="company"
                    placeholder="Company"
                    value={formData.company}
                    onChange={handleChange}
                  />
                  <label htmlFor="company">Company</label>
                </div>

                <div className="form-floating mb-3">
                  <textarea
                    className="form-control no-border-radius"
                    id="requirement"
                    rows="4"
                    placeholder="Requirement"
                    value={formData.requirement}
                    onChange={handleChange}
                  ></textarea>
                  <label htmlFor="requirement">Requirement</label>
                </div>
                <div className="d-flex justify-content-center">
                  <button className="btn submit-btn" type="submit">
                    Submit
                  </button>
                </div>
              </form>
            </motion.div>
            <ToastContainer />
          </div>
          <div className="col-lg-2"></div>
        </div>
      </div>
    </div>
  );
};


export default React.memo(ContactSection);
