import React, { useState, useEffect } from "react";
import { motion } from "framer-motion";
import { Viewer, Worker } from "@react-pdf-viewer/core";
import { defaultLayoutPlugin } from "@react-pdf-viewer/default-layout";
import "@react-pdf-viewer/core/lib/styles/index.css";
import "@react-pdf-viewer/default-layout/lib/styles/index.css";
import apiService, { storage } from "../../services/apiservices";

const ExhibitorsSection = () => {
  const [brouchers, setBrouchers] = useState([]);
  const [selectedTab, setSelectedTab] = useState(0);
  const [error, setError] = useState(null);

  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await apiService.get("brouchers");
        console.log("API Response:", response.data);
        const formattedData = Object.entries(response.data).map(([key, file]) => ({
          label: key.replace(/_/g, " ").toUpperCase(),
          file,
        }));

        setBrouchers(formattedData);
      } catch (err) {
        setError("Failed to fetch data");
      }
    };

    fetchData();
  }, []);

  // Initialize default layout plugin for PDF viewer
  const defaultLayoutPluginInstance = defaultLayoutPlugin();

  return (
    <div>
      <div className="subbaner-exhibitors">
        <div className="text-center breadcrumbs">
          <h4>Exhibitors</h4>
        
        </div>
      </div>

    
      {/* Bootstrap Tabs & PDF Viewer */}
      <div className="mt-2">
        <div className="container">
          {error && <p>{error}</p>}

          {brouchers.length > 0 && (
            <>
              {/* Custom Tabs */}
              <ul className="custom-nav-pills mb-3" id="exhibitorTabs" role="tablist">
                {brouchers.map((tab, index) => (
                  <li key={index} className="custom-nav-item" role="presentation">
                    <a
                      className={`custom-nav-link ${selectedTab === index ? "active" : ""}`}
                      id={`tab-${index}`}
                      data-bs-toggle="pill"
                      href={`#tab-content-${index}`}
                      role="tab"
                      aria-controls={`tab-content-${index}`}
                      aria-selected={selectedTab === index ? "true" : "false"}
                      onClick={() => setSelectedTab(index)}
                    >
                      {tab.label}
                    </a>
                  </li>
                ))}
              </ul>

              {/* PDF Viewer */}
              <motion.div
                initial={{ opacity: 0, y: 10 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.5 }}
                style={{ padding: 20 }}
              >
                <div style={{ display: "flex", justifyContent: "center", marginTop: 20 }}>
                  <Worker workerUrl="https://unpkg.com/pdfjs-dist@3.11.174/build/pdf.worker.js">
                    <div
                      style={{
                        border: "1px solid #ccc",
                        width: "100%",
                        height: "800px",
                        overflow: "auto",
                       
                      }}
                    >
                      <Viewer
                        fileUrl={`${storage}/${brouchers[selectedTab]?.file}`}
                        plugins={[defaultLayoutPluginInstance]}
                      />
                    </div>
                  </Worker>
                </div>
              </motion.div>
            </>
          )}
        </div>
      </div>
    </div>
  );
};


export default React.memo(ExhibitorsSection);

