import React from "react";
import aboutbuild from "../../assets/about/construction.mp4";
import { GoArrowRight } from "react-icons/go";
import SplitText from "../../utils/SplitText";
import { Link } from "react-router-dom";

const About = () => {
  const handleAnimationComplete = () => {

  };

  return (
    <div className="section-padding">
      <div className="container-fluid">
        <div className="row">
          <div className="col-lg-6" data-aos="zoom-in">
            <div>
          
              <video src={aboutbuild} autoPlay muted className="w-100 " />
            </div>
          </div>
          <div
            className="col-lg-6 d-flex align-items-center"
            data-aos="zoom-in"
          >
            <div className="aboutbuild-info_main mb-xs-5 mb-sm-5">
              <div className="aboutbuild-info">
                <div className="">
                  <SplitText
                    text="BUILD INTEC"
                    element="h4"
                    delay={250}
                    animationFrom={{
                      opacity: 0,
                      transform: "translate3d(0,50px,0)",
                    }}
                    animationTo={{
                      opacity: 1,
                      transform: "translate3d(0,0,0)",
                    }}
                    easing="easeOutCubic"
                    threshold={0.2}
                    rootMargin="-50px"
                    onLetterAnimationComplete={handleAnimationComplete}
                  />
            
                </div>
                <h4>2026 <span>-</span> 15ᵗʰ Edition</h4>
                <span className="aboutbuild_span gradient-text">
                  An Event of Codissia Intec Technology Center
                </span>
              </div>
              <div>
                <p>
                  Construction involves the art, trade and work of a building.
                  Behind this genre of creation are the effort, dedication and
                  intelligence of many hands and many brains. In effect, each
                  building is an idea erected to the sky; with the perfect
                  synchronized support of those hands of construction industry.
                  BUILD INTEC 2026, an international construction expo, is
                  conceived to bring together the powers, which render life to
                  the art of construction, under one roof.
                </p>
              </div>

<div className=" mb-3 text-center">
  <a href="" className="d-flex justify-content-end align-items-center" >
    <div className="icon">
      
      <GoArrowRight />
    </div>
    <span className="know-more" > <Link className="know-more" to="/about" > KNOW MORE ABOUT EXPO  </Link> </span>
  </a>
</div>
           


            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default React.memo(About);

