import { useEffect, useState } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import "swiper/css";
import "swiper/css/pagination";
import "swiper/css/navigation";
import { Autoplay, Pagination, Navigation } from "swiper/modules";
import { gsap } from "gsap";
import video1 from "../../assets/home/banner/banner.mp4";
import video2 from "../../assets/home/banner/banner.mp4";
import video3 from "../../assets/home/banner/banner.mp4";
import info from "../../assets/home/banner/info.svg";
import whatsapp from "../../assets/whatsapp.gif";

const slides = [
  { video: video1, info: info },
  { video: video2, info: info },
  { video: video3, info: info },
];

export default function BannerSlider() {
  const [disableNav, setDisableNav] = useState(false);

  useEffect(() => {
    gsap.from(".slider-text", { opacity: 1, y: 50, duration: 1, stagger: 0.5 });
    gsap.from(".yellow-box", { scale: 1, duration: 1, delay: 0.5 });
  }, []);

  const handleSlideChange = (swiper) => {
    if (swiper.activeIndex >= 2) {
      setDisableNav(true);
    }
    swiper.autoplay.stop();
  };

  return (
    <div className="banner-slider-main position-relative">
      <Swiper
        spaceBetween={30}
        centeredSlides={true}
        autoplay={{ delay: 3000, disableOnInteraction: false }} 
        pagination={{
          clickable: true,
          el: ".swiper-pagination",
          type: "bullets",
          clickable: false,
        }}
        navigation={{
          nextEl: ".swiper-button-next",
          prevEl: ".swiper-button-prev",
          disabledClass: "swiper-button-disabled",
        }}
        onSlideChange={handleSlideChange}
        loop={true} 
        modules={[Autoplay, Pagination, Navigation]}
        className="mySwiper"
      >
        {slides.map((slide, index) => (
          <SwiperSlide key={index} className="position-relative">
            <video
              src={slide.video}
              autoPlay
              loop
              muted
              className="w-100 video-height"
            />
            <div className="swiper-button-main">
              <div
                className={`swiper-button-next ${
                  disableNav ? "swiper-button-disabled" : ""
                }`}
              ></div>
              <div
                className={`swiper-button-prev ${
                  disableNav ? "swiper-button-disabled" : ""
                }`}
              ></div>
            </div>
          </SwiperSlide>
        ))}
      </Swiper>
      <div className="whatsapp-icon">
        <a
          href="https://wa.me/7502722000"
          target="_blank"
          rel="noopener noreferrer"
        >
          <img src={whatsapp} alt="WhatsApp" />
        </a>
      </div>
    </div>
  );
}
