import React, { useState } from "react";
import stall from "../../assets/home/bookstall.png";
import {
  Dialog,
  DialogContent,
  TextField,
  MenuItem,
  Button,
  DialogActions,
} from "@mui/material";
import { ToastContainer, toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import apiService from "../../services/apiservices";
const Bookstall = ({ open, handleformclose }) => {
  const [formData, setFormData] = useState({
    company: "",
    email: "",
    mobile: "",
    product_category: "",
    message: "",
  });
  const [errors, setErrors] = useState({});
  const categories = [
    "Construction",
    "Manufacturing",
    "Technology",
    "Healthcare",
    "Education",
  ];
  const handleChange = (e) => {
    setFormData({ ...formData, [e.target.name]: e.target.value });
  };
  const handleSubmit = async (e) => {
    e.preventDefault();
    try {
      const response = await apiService.post("submit-stall", formData);
      setErrors({});
      toast.success("Enquiry submitted successfully!", {
        position: "top-right",
        autoClose: 3000,
        hideProgressBar: false,
        closeOnClick: true,
        pauseOnHover: true,
        draggable: true,
        progress: undefined,
        theme: "light",
      });
  
      // Reset form fields
      setFormData({
        company: "",
        email: "",
        mobile: "",
        product_category: "",
        message: "",
      });
  
      // Optionally close the form (remove this if you don't want it to close)
      // handleformclose(); 
  
    } catch (error) {
      if (error.response && error.response.data.errors) {
        setErrors(error.response.data.errors);
      } else {
        toast.error("Error submitting the form. Please try again.", {
          position: "top-right",
          autoClose: 3000,
          hideProgressBar: false,
          closeOnClick: true,
          pauseOnHover: true,
          draggable: true,
          progress: undefined,
          theme: "light",
        });
      }
    }
  };
  
  return (
    <div>
      <Dialog open={open} onClose={handleformclose} maxWidth="sm" fullWidth>
        <img src={stall} alt="" srcset="" />
        <div className="text-center">
          <h5 className="fw-bold">Exhibitors Registration</h5>
        </div>
        <DialogContent>
          <form onSubmit={handleSubmit}>
            <TextField
              fullWidth
              label="Company Name"
              name="company"
              value={formData.company}
              onChange={handleChange}
              margin="dense"
            />
            {errors.company && (
              <span className="text-danger">{errors.company}</span>
            )}

            <TextField
              fullWidth
              label="Email"
              type="email"
              name="email"
              value={formData.email}
              onChange={handleChange}
              margin="dense"
            />
            {errors.email && (
              <span className="text-danger">{errors.email}</span>
            )}

            <TextField
              fullWidth
              label="Phone Number"
              type="tel"
              name="mobile"
              value={formData.mobile}
              onChange={handleChange}
              margin="dense"
            />
            {errors.mobile && (
              <span className="text-danger">{errors.mobile}</span>
            )}

            <TextField
              fullWidth
              select
              label="Product Category"
              name="product_category"
              value={formData.product_category}
              onChange={handleChange}
              margin="dense"
            >
              {categories.map((product_category, index) => (
                <MenuItem key={index} value={product_category}>
                  {product_category}
                </MenuItem>
              ))}
            </TextField>
            {errors.product_category && (
              <span className="text-danger">{errors.product_category}</span>
            )}

            <TextField
              fullWidth
              label="Message"
              name="message"
              value={formData.message}
              onChange={handleChange}
              margin="dense"
              multiline
              rows={3}
            />
            {errors.message && (
              <span className="text-danger">{errors.message}</span>
            )}

            <DialogActions>
              <button
                className="btn btn-dark"
                onClick={handleformclose}
                color="secondary"
              >
                Close
              </button>

              <button
                className="btn btn-success"
                type="submit"
                variant="contained"
                color="primary"
              >
                Submit
              </button>
            </DialogActions>
          </form>
          <ToastContainer/>
        </DialogContent>
      </Dialog>
    </div>
  );
};

export default React.memo(Bookstall)

