import React, { useEffect, useState, useMemo } from "react";
import aboutbg from "../../assets/about/about-bg.png";
import apiService, { storage } from "../../services/apiservices";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";

const Events = React.memo(() => {
  const [events, setEvents] = useState([]);

  useEffect(() => {
    const getEvents = async () => {
      try {
        const result = await apiService.get("events");
        if (result?.data) {
          setEvents(result.data);
        }
      } catch (error) {
        console.error("Error fetching events:", error);
      }
    };
    getEvents();
  }, []);

  const eventSlides = useMemo(() => {
    return events.flatMap((event, index) =>
      Array(3).fill(null).map((_, repeatIndex) => (
        <SwiperSlide
          key={`${index}-${repeatIndex}`}
          className="event-slide-item"
        >
          <div className="event-item-wrapper">
            <img
              className="event-carousel-image w-100"
              src={`${storage}/${event.image}`}
              alt={event.title || "Event Image"}
              loading="lazy" // Add lazy loading for images
            />
            <div className="event-info">
              <h5 className="event-date">{event.title}</h5>
              <p className="event-description">
                {event.description}
              </p>
            </div>
          </div>
        </SwiperSlide>
      ))
    );
  }, [events]);

  const staticContent = useMemo(() => (
    <div className="events-content-info">
      <div>
        <h4>Innovations & Trends: What's New at Build Intec 2026?</h4>
        <p>
          Coimbatore is set to host Build Intec 2026, a premier
          platform where the brightest minds and most skilled hands in
          the global construction industry come together. This year's
          exhibition at CODISSIA will unveil groundbreaking
          innovations, future-ready solutions, and limitless business
          opportunities.
        </p>
        <p className="mb-5">
          Coimbatore continues to establish itself as a hub for
          industrial excellence, attracting global investments across
          sectors such as housing, malls, star hotels, textiles,
          engineering, IT, and infrastructure. Build Intec 2026 is the
          ultimate destination to witness the latest advancements,
          foster strategic partnerships, and explore the future of
          construction and allied industries.
        </p>
        <span>Join us at Build Intec 2026 !</span>
      </div>
    </div>
  ), []);

  return (
    <section className="section-padding-width">
      <div className="event-carousel-container" data-aos="zoom-in">
        <div className="container-fluid">
          <div>
            <img 
              className="img-fluid about-bg-left" 
              src={aboutbg} 
              alt="" 
              loading="lazy" // Add lazy loading
            />
          </div>
          <div>
            <img 
              className="img-fluid about-bg-right" 
              src={aboutbg} 
              alt="" 
              loading="lazy" // Add lazy loading
            />
          </div>
          <h4 className="event-carousel-title mb-5 mt-5">
            WHATS <span>NEW IN THIS YEAR</span>
          </h4>
          <div className="row">
            <div className="col-lg-6 mb-5">
              <Swiper
                modules={[Navigation, Pagination, Autoplay]}
                pagination={{ clickable: true }}
                autoplay={{ delay: 3000, disableOnInteraction: false }}
                spaceBetween={10}
                slidesPerView={1}
                className="custom-event-slider"
                data-aos="fade-up"
              >
                {eventSlides}
              </Swiper>
            </div>
            <div className="col-lg-6 events-content-main" data-aos="zoom-in">
              {staticContent}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
});


export default React.memo(Events);