import React, { useEffect, useRef } from 'react';


const EventPoster = () => {
  const yellowRectangleRef = useRef(null);

  useEffect(() => {
    const adjustRectangle = () => {
      if (yellowRectangleRef.current) {
        const posterWidth = yellowRectangleRef.current.parentElement.offsetWidth; // Get parent width
        const posterHeight = yellowRectangleRef.current.parentElement.offsetHeight; // Get parent height

        // Calculate dynamic width and height based on poster size
        const rectWidth = posterWidth * 0.8; // Adjust as needed (80% of poster width)
        const rectHeight = posterHeight * 0.25; // Adjust as needed (25% of poster height)

        yellowRectangleRef.current.style.width = `${rectWidth}px`;
        yellowRectangleRef.current.style.height = `${rectHeight}px`;
        yellowRectangleRef.current.style.left = `${(posterWidth - rectWidth) / 2}px`; // Center horizontally
        yellowRectangleRef.current.style.top = `${(posterHeight - rectHeight) / 2}px`; // Center vertically
      }
    };

    // Initial adjustment
    adjustRectangle();

    // Adjust on window resize
    window.addEventListener('resize', adjustRectangle);

    // Clean up listener on component unmount
    return () => window.removeEventListener('resize', adjustRectangle);
  }, []);

  return (
    <div className="container-fluid"> {/* Use fluid container for full width */}
      <div className="row justify-content-center"> {/* Center the poster horizontally */}
        <div className="col-md-8"> {/* Adjust column size for responsiveness */}
          <div className="position-relative"> {/* Needed for absolute positioning of rectangle */}
            <img
              src="your-image.jpg" // Replace with your image path
              alt="Build Intec 2026 Poster"
              className="img-fluid" // Make image responsive
            />
            <div
              ref={yellowRectangleRef}
              className="position-absolute bg-warning border border-dark" // Yellow background, dark border
              style={{             
                // Positioning will be set dynamically in useEffect
                zIndex: 1, // Ensure rectangle is on top of image
                display: 'flex',
                flexDirection: 'column',
                justifyContent: 'center', // Vertically center text
                alignItems: 'center',     // Horizontally center text
                padding: '10px' // Add some padding 
              }}
            >
              <div style={{ color: 'black', textAlign: 'center' }}> {/* Text styles */}
                BUILD INTEC
                <br />
                2026
                <br />
                CODISSIA TRADE FAIR COMPLEX
                <br />
                COIMBATORE, TAMILNADU, INDIA
                <br />
                18TH TO 21ST APRIL 2026
                <br />
                BOOK YOUR STALL K
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};


export default React.memo(EventPoster);