import React, { useState, useRef, useEffect } from "react";
import apiService from "../../services/apiservices";
import { storage } from "../../services/apiservices";
import { gsap } from "gsap";
import exhibitorslogo from "../../assets/home/exhibitors/Exhibitors.png";

export default function Exhibitors() {
  const imgRefs = useRef([]); 
  const [images, setImages] = useState([]);
  const [error, setError] = useState(null);

  const addImageRef = (el, index) => {
    if (el) imgRefs.current[index] = el;
  };

  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await apiService.get("exhibitors-icons");
        if (response.data) {
          const imageArray = Object.values(response.data); 
          setImages(imageArray);
        } else {
          setError("Invalid response structure");
        }
      } catch (err) {
        setError("Failed to fetch data");
      }
    };
    fetchData();
  }, []);

  return (
    <div className="container exhibitors-main">
      <div className="exhibitors-logo">
        <img src={exhibitorslogo} alt="Exhibitors Logo" />
      </div>
      <div className="text-end exhibitors-heading">
        <h4>- EXHIBITORS</h4>
      </div>

      {error && <p className="text-danger text-center">{error}</p>}

      <div className="grid-container-exhibitors">
        {images.length > 0 ? (
          images.map((src, index) => (
            <div
              className="d-flex justify-content-center grid-container-exhibitors-row"
              data-aos="fade-down-right"
              key={index}
              onMouseEnter={() =>
                gsap.to(imgRefs.current[index], {
                  rotationY: 360,
                  rotationX: 360,
                  duration: 1,
                  ease: "power2.out",
                })
              }
              onMouseLeave={() =>
                gsap.to(imgRefs.current[index], {
                  rotationY: 0,
                  rotationX: 0,
                  duration: 1,
                  ease: "power2.in",
                })
              }
            >
              <img
                ref={(el) => addImageRef(el, index)}
                src={`${storage}/${src}`}
                alt={`Exhibitor ${index + 1}`}
                className="logo-img"
              />
            </div>
          ))
        ) : (
          <p className="text-center">Loading images...</p>
        )}
      </div>
    </div>
  );
}

