import React, { useState, } from "react";
import apiService from "../../services/apiservices";

const Newsletter = () => {
  const [email, setEmail] = useState('');
  const [error, setError] = useState('');
  const [success, setSuccess] = useState('');
  const handleEmailChange = (e) => {
    setEmail(e.target.value);
  };

  const handleSubmit = async (e) => {
    e.preventDefault();

    // Reset previous success/error messages
    setError('');
    setSuccess('');

    // Call the API to subscribe
    const result = await apiService.post('subscribe', { email });;
    console.log(result.status);
    if (result.status == 'success') {
      setSuccess('You have successfully subscribed!');
      setEmail('');
    } else {
      setError(result.message.email[0] || 'An error occurred. Please try again.');
    }
  };
  const mapUrl =
    "https://www.google.com/maps/embed?pb=!1m19!1m8!1m3!1d4416.21618903066!2d76.9744031!3d11.0041008!3m2!1i1024!2i768!4f13.1!4m8!3e6!4m0!4m5!1s0x3ba859afc1477e81%3A0x6d10f82f42a7e05e!2sCODISSIA%20Headquarters%20GD%20Naidu%20Towers%20Huzur%20Rd%2C%20Behind%20Court%2C%20Gopalapuram%20Coimbatore%2C%20Tamil%20Nadu%20641018!3m2!1d11.0041008!2d76.9744031!5e1!3m2!1sen!2sin!4v1738325236860!5m2!1sen!2sin";

  return (
    <section className="section-padding-width">
      <div className="container-fluid contact-section section-padding-width">
        <div className="row justify-content-center">
          <div className="col-lg-6" data-aos="zoom-in">
            <div className="map-container">
              <iframe
                src={mapUrl}
                width="100%"
                height="300"
                style={{ border: 0 }}
                allowFullScreen=""
                loading="lazy"
                className="contact-map"
                title="Location Map"
              ></iframe>
            </div>
          </div>

          <div className=" col-lg-6 mb-3 d-flex justify-content-center align-items-center" data-aos="zoom-in">
            <div className="contact-form-container">
              <div>
                <div >
                  <h4 className="contact-title mb-2">    Get In <span> Touch</span> </h4>
                  <div className="messageBox">
                    <input
                      id="messageInput"
                      type="text"
                      placeholder="Enter Your Email Here...."
                      value={email}
                      onChange={handleEmailChange}
                      required
                    />
                    <button id="sendButton" onClick={handleSubmit}>
                      <svg
                        viewBox="0 0 664 663"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M646.293 331.888L17.7538 17.6187L155.245 331.888M646.293 331.888L17.753 646.157L155.245 331.888M646.293 331.888L318.735 330.228L155.245 331.888"
                          fill="none"
                        />
                        <path
                          d="M646.293 331.888L17.7538 17.6187L155.245 331.888M646.293 331.888L17.753 646.157L155.245 331.888M646.293 331.888L318.735 330.228L155.245 331.888"
                          stroke="#6c6c6c"
                          strokeWidth="33.67"
                          strokeLinecap="round"
                          strokeLinejoin="round"
                        />
                      </svg>
                    </button>

                    {/* Display Success or Error messages */}
                   
                  </div>
                  {error && <div className="error-message" style={{color:"red"}}>{error}</div>}
                  {success && <div className="success-message" style={{color:"green"}}>{success}</div>}
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default React.memo(Newsletter);
