import React, { useState, useEffect } from "react";
import Slider from "react-slick";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import quote from "../../assets/home/quote.svg";
import apiService, { storage } from "../../services/apiservices";
const Testimonials =()=> {
  const [testimonials, setTestimonials] = useState([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    async function fetchTestimonials() {
      try {
        const data = await apiService.get("categories");
        setTestimonials(data.data || []);
      } catch (err) {
        setError("Failed to fetch data");
      } finally {
        setLoading(false);
      }
    }

    fetchTestimonials();
  }, []);

  const settings = {
    infinite: true,
    speed: 500,
    dots: true,
    slidesToShow: 2,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 3000,
    centerMode: true,
    centerPadding: "20px",
    cssEase: "linear",
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 2,
          centerPadding: "15px",
        },
      },
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 1,
          centerPadding: "10px",
        },
      },
    ],
  };

  return (
    <div className="section-padding-width" data-aos="zoom-in">
      <div className="container-fluid testimonial-section">
        <h4 className="text-center testimonial-heading mb-5">
          WHATS <span className="highlight-text">PEOPLE ARE SAYING</span>
        </h4>

        <Slider {...settings} className="testimonial-slider">
          {testimonials.map((item, index) => (
            <div key={index} className="testimonial-card">
              <div className="testimonial-content">
                <img
                  src={`${storage}/${item.file_path}`}
                  alt={item.name}
                  className="testimonial-img"
                />
                <div className="testimonial-text">
                  <h5>
                    {item.name} <span className="role"></span>
                  </h5>

                </div>

                <div className="quote-icon">
                  <img src={quote} alt="" srcset="" />
                </div>
              </div>
              <div className="testimonial-des">
                <p>{item.feedback}</p>
              </div>
            </div>
          ))}
        </Slider>
      </div>

      <style>
        {`
         
        `}
      </style>
    </div>
  );
}

export default React.memo(Testimonials)
