import React, { useState, useEffect, useMemo, memo } from "react";
import networking from "../../assets/home/whychooseus_1.gif";
import innovation from "../../assets/home/whychooseus_2.gif";
import comphrehensive from "../../assets/home/whychooseus_3.gif";
import choose from '../../assets/additional/whychooseus.mp4';
import { Link } from "react-router-dom";
import apiService, { storage } from "../../services/apiservices";

const WhyChooseUs = memo(() => {
  const [data, setData] = useState([]);

  useEffect(() => {
    const getData = async () => {
      const result = await apiService.get("forms");
      if (result) {
        setData(result.data);
      }
    };
    getData();
  }, []);

  const cards = useMemo(() => [
    {
      icon: networking,
      title: "NETWORKING OPPORTUNITIES",
      description: "Meet industry leaders, decision-makers and professionals.",
      postion: "1",
    },
    {
      icon: innovation,
      title: "INNOVATION HUB",
      description: "Discover the latest developments in construction technology and sustainability.",
      postion: "2",
    },
    {
      icon: comphrehensive,
      title: "COMPREHENSIVE EXHIBITS",
      description: "Experience a diverse range of products and services under one roof.",
      postion: "3",
    },
  ], []);

  const organizerData = useMemo(() => 
    data.find((item) => item.name === "organizer"), 
  [data]);

  const sponsorsData = useMemo(() => 
    data.filter((item) => item.name === "sponser"), 
  [data]);

  const videoElement = useMemo(() => (
    <div className="col-md-3 d-none d-md-block">
      <video width="100%" height="auto" controls autoPlay loop muted>
        <source src={choose} type="video/mp4" />
        Your browser does not support the video tag.
      </video>
    </div>
  ), []);

  const cardElements = useMemo(() => 
    cards.map((card, index) => (
      <div className="col-md-3 mb-4" key={index}>
        <div className="h-100 whychooseus-card" data-aos="flip-down">
          <div className="whychooseus-card-body">
            <div className="d-flex justify-content-between align-items-center">
              <div>
                <img
                  src={card.icon}
                  alt={card.title}
                  className="card-icon mb-3"
                  loading="lazy"
                />
              </div>
              <div>
                <h2 className="second-heading">{card.postion}</h2>
              </div>
            </div>
            <h3 className="whychooseus-title fw-bold">
              {card.title}
            </h3>
            <p className="whychooseus-description">
              {card.description}
            </p>
          </div>
        </div>
      </div>
    ))
  , [cards]);

  const organizerSection = useMemo(() => (
    <div className="text-center" data-aos="flip-down">
      {organizerData && (
        <a
          href={organizerData.link}
          target="_blank"
          rel="noopener noreferrer"
        >
          <img
            src={`${storage}/${organizerData.file_path}`}
            alt="Organizer"
            loading="lazy"
          />
        </a>
      )}
    </div>
  ), [organizerData]);

const sponsorsSection = useMemo(() => (
  <div className="text-center sponser-main">
    {sponsorsData.length > 0 && (
      <>
        <h4>Platinum Category Exhibitor</h4>
        {sponsorsData.map((sponsor, index) => (
          <a
            key={index}
            href={sponsor.link}
            target="_blank"
            rel="noopener noreferrer"
          >
            <img
              src={`${storage}/${sponsor.file_path}`}
              alt={`Sponsor ${index + 1}`}
              loading="lazy"
            />
          </a>
        ))}
      </>
    )}
  </div>
), [sponsorsData]);


  return (
    <div className="section-padding-width mt-5">
      <div className="container-fluid why-choose-us">
        <div className="row">
          <div className="col-lg-12">
            <h2 className="section-title why-choose-us-heading mb-5">
              WHY<span> BUILD INTEC ?</span>
            </h2>
            <div className="row d-flex justify-content-end">
              {videoElement}
              {cardElements}
            </div>
          </div>
        </div>
      </div>

      <div className="container-fluid organizedby-main">
        <div className="row">
          <div className="col-lg-12 d-flex justify-content-center align-items-center">
            <div>
              {organizerSection}
              <br />
              {sponsorsSection}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
});

export default React.memo(WhyChooseUs);