import { useEffect, useRef, useState } from "react";
import { FaVolumeUp, FaVolumeMute } from "react-icons/fa";
import apiService from "../../services/apiservices";
import { storage } from "../../services/apiservices";

export default function BannerSlider() {
  const videoRef = useRef(null);
  const [isMuted, setIsMuted] = useState(true);
  const [videoSrc, setVideoSrc] = useState(null);
  const [error, setError] = useState(null);

  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await apiService.get("exhibitors");
        if (response.data && response.data) {
          const videoPath = response.data["home video"];
          setVideoSrc(`${storage}/${videoPath}`);
        } else {
          setError("Invalid response structure");
        }
      } catch (err) {
        setError("Failed to fetch video");
      }
    };
    fetchData();
  }, []);

  useEffect(() => {
    const handleScroll = () => {
      if (videoRef.current) {
        const rect = videoRef.current.getBoundingClientRect();
        const isVisible = rect.top >= 0 && rect.bottom <= window.innerHeight;
        isVisible ? videoRef.current.play() : videoRef.current.pause();
      }
    };

    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const toggleMute = () => {
    if (videoRef.current) {
      videoRef.current.muted = !isMuted;
      setIsMuted(!isMuted);
    }
  };

  return (
    <div className="banner-slider-main position-relative">
      {error ? (
        <p className="text-danger text-center">{error}</p>
      ) : videoSrc ? (
        <video
          ref={videoRef}
          src={videoSrc}
          autoPlay
          loop
          muted={isMuted}
          className="w-100 video-height"
        />
      ) : (
        <p className="text-center">Loading video...</p>
      )}

      <button className="volume-control" onClick={toggleMute}>
        {isMuted ? <FaVolumeMute size={24} /> : <FaVolumeUp size={24} />}
      </button>
    </div>
  );
}
