import React ,{ useState,useEffect} from 'react'
import { motion } from "framer-motion";

const Loader = () => {
     const [progress, setProgress] = useState(0);
   
     useEffect(() => {
       let interval = setInterval(() => {
         setProgress((oldProgress) => {
           if (oldProgress >= 100) {
             clearInterval(interval);
             return 100;
           }
           return oldProgress + 5;
         });
       }, 100);
       return () => clearInterval(interval);
     }, []);
   
     return (
       <div className="loader-container">
         <motion.div
           initial={{ rotate: 0 }}
           animate={{ rotate: 360 }}
           transition={{ repeat: Infinity, duration: 1, ease: "linear" }}
           className="loader-circle"
         ></motion.div>
         <p className="loader-text">{progress}%</p>
         <div className="progress-bar">
           <motion.div
             initial={{ width: "0%" }}
             animate={{ width: `${progress}%` }}
             transition={{ duration: 1 }}
             style={{
               height: "100%",
               background: "#ffcc00",
               borderRadius: "10px",
             }}
           ></motion.div>
         </div>
       </div>
     );
   };

export default Loader
