import React, { useEffect, useState, useCallback, memo,useMemo } from 'react';
import popup from '../assets/additional/popup.jpg';

const Popupscreen = memo(() => {
  const [showPopup, setShowPopup] = useState(false);

  useEffect(() => {
    const timer = setTimeout(() => {
      setShowPopup(true);
    }, 3000);

    return () => clearTimeout(timer);
  }, []);

  const closePopup = useCallback(() => {
    setShowPopup(false);
  }, []);

  const popupContent = useMemo(() => (
    <div className="popup-overlay">
      <div className="popup-content">
        <button className="close-btn-up" onClick={closePopup}>&times;</button>
        <a target='_blank' rel="noopener noreferrer" href="https://visitor.codissia.com/">
          <img className='img-fluid' src={popup} alt="Popup" loading="lazy" />
        </a>
      </div>
    </div>
  ), [closePopup]);

  return showPopup ? popupContent : null;
});

export default Popupscreen;