import { motion } from "framer-motion";

import { Container, Row, Col } from "react-bootstrap";
import visitors from "../../assets/visitors.gif";
import { MdKeyboardDoubleArrowLeft } from "react-icons/md";
import {
  FaBuilding,
  FaUsers,
  FaUniversity,
  FaLightbulb,
  FaProjectDiagram,
  FaNewspaper,
} from "react-icons/fa";

const categories = [
  {
    icon: <FaBuilding />,
    title: "Industry Professionals",
    items: ["Architects", "Builders", "Consulting Engineers", "Contractors"],
  },
  {
    icon: <FaUsers />,
    title: "Business & Trade Experts",
    items: [
      "Distributors & Dealers",
      "Machinery & Equipment Dealers",
      "Investors in Construction",
    ],
  },
  {
    icon: <FaUniversity />,
    title: "Institutional & Govt Representatives",
    items: [
      "Educational Institutions",
      "Government Officials",
      "Public Sector Companies",
    ],
  },
  {
    icon: <FaLightbulb />,
    title: "Design & Engineering Specialists",
    items: [
      "HVAC Consultants",
      "Interior Designers",
      "Lighting Consultants",
      "Mechanical & Electrical Engineers",
      "Structural & Civil Engineers",
    ],
  },
  {
    icon: <FaProjectDiagram />,
    title: "Business & Project Leaders",
    items: [
      "Property Developers",
      "Procurement & Purchase Heads",
      "Promoters & Project Managers",
    ],
  },
  {
    icon: <FaNewspaper />,
    title: "Media & Coverage",
    items: [
      "Media Representatives",
      "Print Media",
      "PR Activity",
      "Electronic Media",
      "Outdoor Media",
      "Social Media",
    
    ],
  },
];

const VisitorsProfile = () => {
  return (
    <section>
      <div>
        <div className="subbaner-visitors">
          <div className="text-center breadcrumbs">
            <h4>Visitors Profile</h4>
          
          </div>
        </div>
      </div>
     
      <div className="text-center mt-3">
        <div className="enroll-now" >
          <a target="_blank" href="https://visitor.codissia.com/">
            Register Now
          </a>
        </div>
      </div>
      <Container className="py-4">
        <motion.h4
          className="text-center fw-bold mb-4 visitors-heading text-center"
          initial={{ opacity: 0, y: -20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5 }}
        >
          Our exhibition welcomes a diverse group of industry professionals,
          decision-makers, and key stakeholders who drive the construction and
          infrastructure sectors forward. Whether you are seeking innovative
          solutions, networking opportunities, or industry insights, our event
          caters to a wide range of professionals, including:
        </motion.h4>
        <Row className="g-4">
          {categories.map((category, index) => (
            <Col key={index} md={6} lg={4}>
              <motion.div
                className="category-card p-4 text-center position-relative"
                transition={{ duration: 0.3 }}
              >
                <div className="fs-2 mb-2 category-card-icon">
                  {category.icon}
                </div>
                <h5 className="fw-bold">{category.title}</h5>
                <ul className="list-unstyled mt-2">
                  {category.items.map((item, idx) => (
                    <motion.li
                      key={idx}
                      className="small text-muted"
                      initial={{ opacity: 0, x: -10 }}
                      animate={{ opacity: 1, x: 0 }}
                      transition={{ delay: idx * 0.1 }}
                    >
                      {item}
                    </motion.li>
                  ))}
                </ul>
              </motion.div>
            </Col>
          ))}
        </Row>
      </Container>
    </section>
  );
};

export default VisitorsProfile;
