import React, { useState, useEffect, useRef } from "react";
import logo from "../assets/footer-logo.png";
import clouddreams from "../assets/clouddreams.svg";
import { Link } from "react-router-dom";
import { FaInstagram, FaFacebook } from "react-icons/fa";
import { FiCornerDownRight } from "react-icons/fi";
import { ImLocation } from "react-icons/im";
import { IoMdCall } from "react-icons/io";
import { MdOutlineMarkEmailUnread } from "react-icons/md";
import apiService from "../services/apiservices";
import { storage } from "../services/apiservices";

const Footer = () => {
  const [images, setImages] = useState([]);
  const [error, setError] = useState(null);
  const logoRef = useRef(null);
  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await apiService.get("logo");

        setImages(Array.isArray(response.data) ? response.data : []);
      } catch (err) {
        setError("Failed to fetch data");
      }
    };
    fetchData();
  }, []);
  return (
    <div>
      <footer className="section-padding-width  ">
        <div className=" unique-footer p-4 ">
          <div className="row">
            <div className="row">
              <div className="col-sm-6 col-md-6 col-lg-3 mb-4">
                <div className="mt-4">
                  <Link to="/">
                    {Array.isArray(images) && images.length > 0 ? (
                      images.map((item, index) => (
                        <div key={index}>
                          <img
                            ref={logoRef}
                            src={`${storage}/${item}`}
                            alt="Logo"
                          />
                        </div>
                      ))
                    ) : (
                      <img ref={logoRef} src={logo} alt="Default Logo" />
                    )}
                  </Link>

                  <div className="social-icons mt-2 ">
                    <Link
                      href="https://www.instagram.com"
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      <FaInstagram size={20} />
                    </Link>
                    <Link
                      href="https://www.facebook.com"
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      <FaFacebook size={20} />
                    </Link>
                  </div>
                </div>
              </div>

              <div className="col-sm-6 col-md-6 col-lg-3 mb-4">
                <h5>Contact Us</h5>
                <div className="d-flex ">
                  <span>
                    <ImLocation />
                  </span>
                  <p>
                    <a href="https://www.google.com/maps/embed?pb=!1m19!1m8!1m3!1d4416.21618903066!2d76.9744031!3d11.0041008!3m2!1i1024!2i768!4f13.1!4m8!3e6!4m0!4m5!1s0x3ba859afc1477e81%3A0x6d10f82f42a7e05e!2sCODISSIA%20Headquarters%20GD%20Naidu%20Towers%20Huzur%20Rd%2C%20Behind%20Court%2C%20Gopalapuram%20Coimbatore%2C%20Tamil%20Nadu%20641018!3m2!1d11.0041008!2d76.9744031!5e1!3m2!1sen!2sin!4v1738325236860!5m2!1sen!2sin">
                      CODISSIA TRADE FAIR COMPLEX, <br />
                      G.V. Fair Grounds, <br />
                      Avinashi Road, <br />
                      Coimbatore – 641014, <br />
                      Tamil Nadu, India.
                    </a>
                  </p>
                </div>
              </div>
              <div className="col-sm-6 col-md-6 col-lg-3 mb-4">
                <h5>Reach Now</h5>

                <li>
                  <span>
                    <IoMdCall />
                  </span>
                  <a href="tel:+917502722000">Phone: +91 75027 22000 </a>
                </li>
                

                <li>
                  <span>
                    <MdOutlineMarkEmailUnread />
                  </span>

                  <a href="mailto:buildintec@codissia.com">buildintec@codissia.com </a>
                </li>
              </div>
              <div className="col-sm-6 col-md-6 col-lg-3 mb-4">
                <div>
                  <h5>Navigation</h5>
                  <li>
                    <Link to="/">
                      <span>
                        <FiCornerDownRight />
                      </span>
                      Home
                    </Link>
                  </li>
                  <li>
                    <Link to="/about">
                      <span>
                        <FiCornerDownRight />
                      </span>
                      About Us
                    </Link>
                  </li>
                  <li>
                    <Link to="/exhibitors">
                      <span>
                        <FiCornerDownRight />
                      </span>
                      Exhibitors
                    </Link>
                  </li>
                  <li>
                    <Link to="/gallery">
                      <span>
                        <FiCornerDownRight />
                      </span>
                      Gallery
                    </Link>
                  </li>
                  <li>
                    <Link to="/contact">
                      <span>
                        <FiCornerDownRight />
                      </span>
                      Contact
                    </Link>
                  </li>
                  <div>
                    <li>
                      <Link to="/termsconditions">
                        <span>
                          <FiCornerDownRight />
                        </span>
                        Terms & Conditions
                      </Link>
                    </li>
                    <li>
                      <Link to="/privacypolicy">
                        <span>
                          <FiCornerDownRight />
                        </span>
                        Privacy Policy
                      </Link>
                    </li>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </footer>
      <div className=" mt-2 mb-3 ps-5 pe-5 container-fluid">
        <div className="d-flex justify-content-between section-padding-width flex-column flex-sm-row unique-footer-sub">
          <div>
            <div>
              <p>
                © {new Date().getFullYear()} - Codissia. All rights reserved
              </p>
            </div>
          </div>
          <div>
            <p>
              Website designed by
              <span>
                <a href="https://www.clouddreams.in/" target="_blank">
                  {" "}
                  <img src={clouddreams} alt="" srcset="" />{" "}
                </a>
              </span>
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Footer;
