import React, { useState, useEffect, useRef } from "react";
import {
  Navbar,
  Container,
  Nav,
  Offcanvas,
  NavDropdown,
} from "react-bootstrap";
import gsap from "gsap";
import logo from "../assets/logo.svg";
import toggle from "../assets/hamburger.png";

import { Link } from "react-router-dom";
import apiService from "../services/apiservices";
import { storage } from "../services/apiservices";
import Bookstall from "../Components/Home/Bookstall";

const Header = () => {
  const [show, setShow] = useState(false);
  const [navbarBg, setNavbarBg] = useState(false);
  const [dropdownOpen, setDropdownOpen] = useState(false);
  const logoRef = useRef(null);
  const [images, setImages] = useState([]);
  const [error, setError] = useState(null);

  const [open, setOpen] = useState(false);

  const handleformOpen = () => setOpen(true);
  const handleClose = () => {
    setShow(false);
    setDropdownOpen(false);
  };
  const handleformClose = () => setOpen(false);
  const handleShow = () => setShow(true);

  useEffect(() => {
    const handleScroll = () => setNavbarBg(window.scrollY > 50);
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  useEffect(() => {
    gsap.fromTo(
      logoRef.current,
      { scale: 0.5, opacity: 0 },
      { scale: 1.1, opacity: 1, duration: 1, delay: 1, ease: "back.out(1.7)" }
    );
  }, []);

  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await apiService.get("logo");
        setImages(Array.isArray(response.data) ? response.data : []);
      } catch (err) {
        setError("Failed to fetch data");
      }
    };
    fetchData();
  }, []);

  return (
    <>
      <Navbar
        expand="lg"
        className={`fixed-top navbar-main ${navbarBg ? "navbar-scrolled" : ""}`}
      >
        <Container className="navbar-container">
          <Navbar.Brand>
            <Link to="/">
              {Array.isArray(images) && images.length > 0 ? (
                images.map((item, index) => (
                  <div key={index}>
                    <img ref={logoRef} src={`${storage}/${item}`} alt="Logo" />
                  </div>
                ))
              ) : (
                <img ref={logoRef} src={logo} alt="Default Logo" />
              )}
            </Link>
          </Navbar.Brand>

          <Nav className="ms-auto d-none d-lg-flex">
            <Nav.Link href="#home" className="nav-active">
              <Link to="/"> Home </Link>
            </Nav.Link>

            <NavDropdown
              title="About Us"
              show={dropdownOpen}
              onMouseEnter={() => setDropdownOpen(true)}
              onMouseLeave={() => setDropdownOpen(false)}
            >
              <NavDropdown.Item>
                <Link to="/about"> ABOUT BUILDINTEC </Link>
              </NavDropdown.Item>
              <NavDropdown.Item>
                <Link to="/codissiainfo"> ABOUT CODISSIA </Link>
              </NavDropdown.Item>
            </NavDropdown>

            <Nav.Link>
              <Link to="/exhibitors"> Exhibitors </Link>
            </Nav.Link>
            <Nav.Link>
              <Link to="/gallery">Gallery </Link>
            </Nav.Link>
            <Nav.Link>
              <Link to="/contact"> Contact </Link>
            </Nav.Link>
            <div
              id="book_your_stall"
              onClick={handleformOpen}
              style={{ cursor: "pointer" }}
            >
              Book Your Stall
            </div>
          </Nav>
          <div className="d-flex align-items-center">
            <button
              className="btn custom-toggler d-lg-none"
              onClick={handleShow}
            >
              <img style={{ width: "40px" }} src={toggle} alt="Menu" />
            </button>
          </div>

          <Offcanvas show={show} onHide={handleClose} placement="end">
            <Offcanvas.Header closeButton>
              <Offcanvas.Title>
                <Link to="/">
                  {" "}
                  {Array.isArray(images) && images.length > 0 ? (
                    images.map((item, index) => (
                      <div key={index}>
                        <img
                          style={{ width: "200px" }}
                          ref={logoRef}
                          src={`${storage}/${item}`}
                          alt="Logo"
                        />
                      </div>
                    ))
                  ) : (
                    <img  ref={logoRef} src={logo} alt="Default Logo logo-mobile" />
                  )}{" "}
                </Link>
              </Offcanvas.Title>
            </Offcanvas.Header>
            <Offcanvas.Body>
              <Nav className="ms-auto d-lg-none">
                <Nav.Link href="#home" className="">
                  <Link to="/"> Home </Link>
                </Nav.Link>
                <NavDropdown
                  title="About Us"
                  show={dropdownOpen}
                  onMouseEnter={() => setDropdownOpen(true)}
                  onMouseLeave={() => setDropdownOpen(false)}
                >
                  <NavDropdown.Item>
                    <Link to="/about"> ABOUT BUILDINTEC </Link>
                  </NavDropdown.Item>
                  <NavDropdown.Item>
                    <Link to="/codissiainfo"> ABOUT CODISSIA </Link>
                  </NavDropdown.Item>
                </NavDropdown>
                <Nav.Link>
                  <Link to="/exhibitors">Exhibitors </Link>
                </Nav.Link>
                <Nav.Link>
                  {" "}
                  <Link to="/gallery">Gallery </Link>
                </Nav.Link>
                <Nav.Link>
                  {" "}
                  <Link to="/contact">Contact </Link>
                </Nav.Link>
                <div
                  className="ps-2"
                  id="book_your_stall"
                  onClick={handleformOpen}
                  style={{ cursor: "pointer" }}
                >
                  Book Your Stall
                </div>
                <Nav.Link></Nav.Link>
              </Nav>
            </Offcanvas.Body>
          </Offcanvas>
        </Container>
      </Navbar>
      <Bookstall open={open} handleformclose={handleformClose} />
    </>
  );
};

export default Header;
