import React, { useState, useEffect, useRef } from "react";
import lang from "../assets/language.svg";

const Language = () => {
  const [isOpen, setIsOpen] = useState(false);
  const dropdownRef = useRef(null);

  const toggleDropdown = () => {
    setIsOpen(!isOpen);
  };

  useEffect(() => {
    const handleClickOutside = (event) => {
      if (dropdownRef.current && !dropdownRef.current.contains(event.target)) {
        setIsOpen(false);
      }
    };

    document.addEventListener("mousedown", handleClickOutside);
    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, []);

  useEffect(() => {
    if (!window.googleTranslateElementInit) {
      window.googleTranslateElementInit = () => {
        new window.google.translate.TranslateElement(
          {
            pageLanguage: "en",
            includedLanguages: "en,ta,hi",
            layout: window.google.translate.TranslateElement.InlineLayout.SIMPLE,
          },
          "google_translate_element"
        );
      };

      const script = document.createElement("script");
      script.src = "https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit";
      script.async = true;
      document.body.appendChild(script);
    }
  }, []);

  const changeLanguage = (langCode) => {
    const selectElement = document.querySelector(".goog-te-combo");
    if (selectElement) {
      selectElement.value = langCode;
      selectElement.dispatchEvent(new Event("change"));
    }
  };

  return (
    <div className="language-main d-none">
      <div className="language-dropdown" ref={dropdownRef}>
      
        {isOpen && (
          <div className="language-dropdown-menu">
            <ul>
              <li onClick={() => changeLanguage("en")}>English</li>
              <li onClick={() => changeLanguage("ta")}>Tamil</li>
              <li onClick={() => changeLanguage("hi")}>Hindi</li>
            </ul>
          </div>
        )}
      </div>
      {/* Google Translate Widget */}
      <div id="google_translate_element" ></div>
    </div>
  );
};

export default Language;
