import React, { useState, useEffect } from "react";
import { Link } from "react-router-dom";
import toggle from "../assets/hamburger.png";
import logo from "../assets/logo.png";
import apiService, { storage } from "../services/apiservices";
import Bookstall from "../Components/Home/Bookstall";
import { CiLocationOn } from "react-icons/ci";

const Navbar = () => {
  const [images, setImages] = useState([]);
  const [dropdownOpen, setDropdownOpen] = useState(false);
  const [showOffcanvas, setShowOffcanvas] = useState(false);
  const [open, setOpen] = useState(false);
  const [isRegistrationOpen, setIsRegistrationOpen] = useState(false);
  const handleformOpen = () => setOpen(true);
  const handleformClose = () => setOpen(false);
  const toggleOffcanvas = () => {
    setShowOffcanvas(!showOffcanvas);
  };
  const handleRegistrationToggle = () => {
    setIsRegistrationOpen((prev) => !prev);
  };
  const handleLinkClick = () => {
    setDropdownOpen(false);
    setShowOffcanvas(false);
    const offcanvasElement = document.getElementById("offcanvasExample");
    const offcanvas = new bootstrap.Offcanvas(offcanvasElement);
    offcanvas.hide();
  };
  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await apiService.get("logo");
        if (response.data && response.data.profile_url) {
          setImages([response.data]);
        }
      } catch (err) {
        console.error("Failed to fetch data");
      }
    };
    fetchData();
  }, []);
  return (
    <>
      {/* Navbar Section */}
      <nav className="navbar navbar-new navbar-expand-lg d-flex flex-column align-items-center">
        <div className="navbar-brand ">
          <Link to="/">
            {images.length > 0 ? (
              images.map((item, index) => (
                <div key={index}>
                  <img src={`${storage}/${item.profile_url}`} alt="Logo" />
                </div>
              ))
            ) : (
              <img src={logo} alt="Default Logo" />
            )}
          </Link>
          <div>
            {images.length > 0 && // Fixed the issue here
              images.map((item, index) => (
                <div key={index}>
                  <div className="d-flex justify-content-center ">
                    <p className="event-date ">{item.date}</p>
                  </div>
                  <div className="d-flex flex-column event-location-location">
                    <div className="d-flex  justify-content-center">
                    <div>
                      <CiLocationOn style={{width:"30px",fontSize:"25px"}} />
                    </div>
                    <div>
                      <span>CODISSIA TRADE FAIR COMPLEX</span>
                      <br />
                      <span> Coimbatore, Tamil Nadu, INDIA</span>
                    </div>
                    </div>
                 
                  </div>
                </div>
              ))}
          </div>
        </div>

        {/* Offcanvas Toggle Button */}
        <button
          className="navbar-toggler position-absolute  end-0 mt-3"
          type="button"
          onClick={toggleOffcanvas}
        >
          <img style={{ width: "30px" }} src={toggle} alt="Menu" />
        </button>

        {/* Navigation Links */}
        <div className="collapse navbar-collapse" id="navbarNav">
          <ul className="navbar-nav text-center">
            <li className="nav-item">
              <Link
                className="nav-link text-dark"
                to="/"
                onClick={handleLinkClick}
              >
                Home
              </Link>
            </li>

            {/* About Dropdown */}
            <li className="nav-item dropdown">
              <Link
                className="nav-link dropdown-toggle text-dark"
                to="#"
                id="aboutDropdown"
              >
                About Us
              </Link>
              <ul className="dropdown-menu" aria-labelledby="aboutDropdown">
                <li>
                  <Link
                    className="dropdown-item"
                    to="/about"
                    onClick={handleLinkClick}
                  >
                    About build intec
                  </Link>
                </li>
                <li>
                  <Link
                    className="dropdown-item"
                    to="/codissiainfo"
                    onClick={handleLinkClick}
                  >
                    About codissia
                  </Link>
                </li>
              </ul>
            </li>

            <li className="nav-item">
              <Link
                className="nav-link text-dark"
                to="/exhibitors"
                onClick={handleLinkClick}
              >
                Exhibitors
              </Link>
            </li>
            <li className="nav-item">
              <Link
                className="nav-link text-dark"
                to="/visitors"
                onClick={handleLinkClick}
              >
                Visitors
              </Link>
            </li>
            <li className="nav-item">
              <Link
                className="nav-link text-dark"
                to="/gallery"
                onClick={handleLinkClick}
              >
                Gallery
              </Link>
            </li>
            <li className="nav-item">
              <Link
                className="nav-link text-dark"
                to="/contact"
                onClick={handleLinkClick}
              >
                Contact
              </Link>
            </li>

            {/* Registration Dropdown */}
            <li className="nav-item dropdown">
              <Link
                className=" dropdown-toggle text-dark"
                to="#"
                id="registrationDropdown"
              >
                Registration
              </Link>
              <ul
                className="dropdown-menu"
                aria-labelledby="registrationDropdown"
              >
                <li>
                  <Link className="dropdown-item" onClick={handleformOpen}>
                    Exhibitor Registration
                  </Link>
                </li>
                <li>
                  <a
                    className="dropdown-item"
                    href="https://visitor.codissia.com/"
                    target="_blank"
                    rel="noopener noreferrer"
                    onClick={handleLinkClick}
                  >
                    Visitor Registration
                  </a>
                </li>
              </ul>
            </li>
          </ul>
        </div>
      </nav>

      {/* Offcanvas Menu for Mobile */}
      <div
        className={`offcanvas offcanvas-top bg-dark ${
          showOffcanvas ? "show" : ""
        }`}
        id="offcanvasNavbar"
      >
        <div className="offcanvas-header">
          <h5 className="offcanvas-title flex-column d-flex">
            <Link to="/">
              {images.length > 0 ? (
                images.map((item, index) => (
                  <div key={index}>
                    <img
                      className="logo-mobile"
                      src={`${storage}/${item.profile_url}`}
                      alt="Logo"
                    />
                    {item.date && <p className="event-date">{item.date}</p>}
                  </div>
                ))
              ) : (
                <img src={logo} alt="Default Logo logo-mobile" />
              )}
            </Link>
          </h5>
          <button
            type="button"
            className="btn-close btn-close-dark"
            onClick={toggleOffcanvas}
          ></button>
        </div>

        <div className="offcanvas-body">
          <ul className="navbar-nav">
            <li className="nav-item">
              <Link
                className="nav-link text-dark"
                to="/"
                onClick={handleLinkClick}
              >
                Home
              </Link>
            </li>

            {/* About Dropdown */}
            <li className="nav-item dropdown">
              <ul className="list-unstyled">
                <li className="dropdown">
                  <a
                    href="#"
                    className="nav-link dropdown-toggle"
                    id="aboutDropdown"
                    role="button"
                    data-bs-toggle="dropdown"
                    aria-expanded="false"
                    onMouseEnter={() => setDropdownOpen(true)}
                    onMouseLeave={() => setDropdownOpen(false)}
                    onClick={(e) => e.preventDefault()} // Prevents the default action of the link
                  >
                    About Us
                  </a>
                  <ul
                    className={`dropdown-menu ${dropdownOpen ? "show" : ""}`}
                    aria-labelledby="aboutDropdown"
                  >
                    <li>
                      <Link
                        to="/about"
                        className="dropdown-item"
                        onClick={() => {
                          handleLinkClick();
                          setDropdownOpen(false);
                          closeOffcanvas();
                        }}
                      >
                        ABOUT BUILDINTEC
                      </Link>
                    </li>
                    <li>
                      <Link
                        to="/codissiainfo"
                        className="dropdown-item"
                        onClick={() => {
                          handleLinkClick();
                          setDropdownOpen(false);
                          closeOffcanvas();
                        }}
                      >
                        ABOUT CODISSIA
                      </Link>
                    </li>
                  </ul>
                </li>
              </ul>
            </li>

            <li className="nav-item">
              <Link
                className="nav-link text-dark"
                to="/exhibitors"
                onClick={handleLinkClick}
              >
                Exhibitors
              </Link>
            </li>
            <li className="nav-item">
              <Link
                className="nav-link text-dark"
                to="/visitors"
                onClick={handleLinkClick}
              >
                Visitors
              </Link>
            </li>
            <li className="nav-item">
              <Link
                className="nav-link text-dark"
                to="/gallery"
                onClick={handleLinkClick}
              >
                Gallery
              </Link>
            </li>
            <li className="nav-item">
              <Link
                className="nav-link text-dark"
                to="/contact"
                onClick={handleLinkClick}
              >
                Contact
              </Link>
            </li>

            {/* Registration Dropdown */}
            <li>
              <Link
                className="dropdown-toggle text-dark"
                to="#"
                id="registrationDropdown"
                onClick={handleRegistrationToggle}
              >
                Registration
              </Link>
              <ul
                className={`dropdown-menu ${isRegistrationOpen ? "show" : ""}`}
                aria-labelledby="registrationDropdown"
              >
                <li>
                  <Link className="dropdown-item" onClick={handleformOpen}>
                    Exhibitor Registration
                  </Link>
                </li>
                <li>
                  <a
                    className="dropdown-item"
                    href="https://visitor.codissia.com/"
                    target="_blank"
                    rel="noopener noreferrer"
                    onClick={handleLinkClick}
                  >
                    Visitor Registration
                  </a>
                </li>
              </ul>
            </li>
          </ul>
        </div>
      </div>
      <Bookstall open={open} handleformclose={handleformClose} />
    </>
  );
};

export default React.memo(Navbar);
