import React, { useState, useEffect, useRef } from "react";
import { Dropdown } from "react-bootstrap";
import {
  Navbar,
  Container,
  Nav,
  Offcanvas,
  NavDropdown,
} from "react-bootstrap";
import gsap from "gsap";
import logo from "../assets/logo.svg";
import toggle from "../assets/hamburger.png";
import Language from "./Language";
import { Link } from "react-router-dom";
import apiService from "../services/apiservices";
import { storage } from "../services/apiservices";
import Bookstall from "../Components/Home/Bookstall";

const Navigation = () => {
  const [show, setShow] = useState(false);
  const [navbarBg, setNavbarBg] = useState(false);
  const [dropdownOpen, setDropdownOpen] = useState(false);
  const logoRef = useRef(null);
  const [images, setImages] = useState([]);
  const [error, setError] = useState(null);
  const [open, setOpen] = useState(false);
  const handleformOpen = () => setOpen(true);
  const handleClose = () => {
    setShow(false);
    setDropdownOpen(false);
  };
  const handleformClose = () => setOpen(false);
  const handleShow = () => setShow(true);

  useEffect(() => {
    const handleScroll = () => setNavbarBg(window.scrollY > 50);
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  useEffect(() => {
    gsap.fromTo(
      logoRef.current,
      { scale: 0.5, opacity: 0 },
      { scale: 1.1, opacity: 1, duration: 1, delay: 1, ease: "back.out(1.7)" }
    );
  }, []);

   useEffect(() => {
     const fetchData = async () => {
       try {
         const response = await apiService.get("logo");
         setImages(Array.isArray(response.data) ? response.data : []);
       } catch (err) {
         setError("Failed to fetch data");
       }
     };
     fetchData();
   }, []);
 

  return (
    <>
      <Navbar
        expand="lg"
        className={` navbar-main fixed-top ${
          navbarBg ? "navbar-scrolled" : ""
        }`}
      >
        <div className="navbar-container-fluid container-fluid">
          <Navbar.Brand>
            <Link to="/">
              {Array.isArray(images) && images.length > 0 ? (
                images.map((item, index) => (
                  <div key={index}>
                    <img ref={logoRef} src={`${storage}/${item}`} alt="Logo" />
                  </div>
                ))
              ) : (
                <img ref={logoRef} src={logo} alt="Default Logo" />
              )}
            </Link>
          </Navbar.Brand>

          <Nav className="ms-auto d-none d-lg-flex">
            <Nav.Link href="#home" className="">
              <Link to="/"> Home </Link>
            </Nav.Link>

            <NavDropdown
              title="About Us"
              show={dropdownOpen}
              onMouseEnter={() => setDropdownOpen(true)}
              onMouseLeave={() => setDropdownOpen(false)}
            >
              <NavDropdown.Item>
                <Link to="/about"> ABOUT BUILDINTEC </Link>
              </NavDropdown.Item>
              <NavDropdown.Item>
                <Link to="/codissiainfo"> ABOUT CODISSIA </Link>
              </NavDropdown.Item>
            </NavDropdown>

            <Nav.Link>
              <Link to="/exhibitors"> Exhibitors </Link>
            </Nav.Link>
            <Nav.Link>
              <Link to="/visitors"> Visitors </Link>
            </Nav.Link>
            <Nav.Link>
              <Link to="/gallery">Gallery </Link>
            </Nav.Link>
            <Nav.Link>
              <Link to="/contact"> Contact </Link>
            </Nav.Link>
            <Dropdown>
              <Dropdown.Toggle
                variant="link"
               id="book_your_stall"
                style={{
                  cursor: "pointer",
                  border: "none",
                  background: "none",
                }}
              >
                Registration
              </Dropdown.Toggle>

              <Dropdown.Menu>
                <Dropdown.Item onClick={handleformOpen} >
                Exhibitors Registration
                </Dropdown.Item>
                <Dropdown.Item as={Link} to="https://visitor.codissia.com/">
                  Visitor Registration
                </Dropdown.Item>
              </Dropdown.Menu>
            </Dropdown>
          </Nav>
          <div className="d-flex align-items-center">
            <Language />
            <button
              className="btn custom-toggler d-lg-none"
              onClick={handleShow}
            >
              <img style={{ width: "40px" }} src={toggle} alt="Menu" />
            </button>
          </div>

          <Offcanvas show={show} onHide={handleClose} placement="top">
            <Offcanvas.Header closeButton>
              <Offcanvas.Title>
                <Link to="/">
                  {" "}
                  {Array.isArray(images) && images.length > 0 ? (
                    images.map((item, index) => (
                      <div key={index}  onClick={handleClose}>
                        <img
                          style={{ width: "200px" }}
                          ref={logoRef}
                          src={`${storage}/${item}`}
                          alt="Logo"
                        />
                      </div>
                    ))
                  ) : (
                    <img ref={logoRef} src={logo}   style={{ width: "200px" }} alt="Default Logo logo-mobile"  onClick={handleClose} />
                  )}{" "}
                </Link>
              </Offcanvas.Title>
            </Offcanvas.Header>
            <Offcanvas.Body>
              <Nav className=" d-lg-none">
                <Nav.Link href="#home" className="">
                  <Link to="/"> Home </Link>
                </Nav.Link>

                <NavDropdown
                  title="About Us"
                  show={dropdownOpen}
                  onMouseEnter={() => setDropdownOpen(true)}
                  onMouseLeave={() => setDropdownOpen(false)}
                >
                  <NavDropdown.Item>
                    <Link to="/about"  onClick={handleClose} > ABOUT BUILDINTEC </Link>
                  </NavDropdown.Item>
                  <NavDropdown.Item>
                    <Link to="/codissiainfo"  onClick={handleClose} > ABOUT CODISSIA </Link>
                  </NavDropdown.Item>
                </NavDropdown>
                <Nav.Link>
                  <Link to="/exhibitors"  onClick={handleClose}>Exhibitors </Link>
                </Nav.Link>
                <Nav.Link>
                  <Link to="/visitors"  onClick={handleClose}>Visitors </Link>
                </Nav.Link>
                <Nav.Link>
                  {" "}
                  <Link to="/gallery" onClick={handleClose}>Gallery </Link>
                </Nav.Link>
                <Nav.Link>
                  {" "}
                  <Link to="/contact"  onClick={handleClose}>Contact </Link>
                </Nav.Link>
                <Dropdown>
                  <Dropdown.Toggle
                    variant="link"
                    id="book_your_stall"
                    style={{
                      cursor: "pointer",
                      border: "none",
                      background: "none",
                    }}
                  >
                    Registration
                  </Dropdown.Toggle>

                  <Dropdown.Menu>
                    <Dropdown.Item onClick={handleformOpen}  >
                    Exhibitors Registration
                    </Dropdown.Item>
                    <Dropdown.Item as={Link} to="https://visitor.codissia.com/">
                      Visitor Registration
                    </Dropdown.Item>
                  </Dropdown.Menu>
                </Dropdown>
                <Nav.Link></Nav.Link>
              </Nav>
            </Offcanvas.Body>
          </Offcanvas>
        </div>
      </Navbar>
      <Bookstall open={open} handleformclose={handleformClose} />
    </>
  );
};

export default Navigation;
