import React, { useState, useEffect } from 'react';
import { FiCornerRightUp } from "react-icons/fi";

const BackToTop = () => {
  const [showButton, setShowButton] = useState(false);
  const scrollThreshold = 500;

  useEffect(() => {
    const handleScroll = () => {
      setShowButton(window.scrollY > scrollThreshold);
    };
    window.addEventListener('scroll', handleScroll);
    return () => window.removeEventListener('scroll', handleScroll);
  }, []);

  const scrollToTop = () => {
    window.scrollTo({
      top: 0,
      behavior: 'smooth',
    });
  };

  return (
    <button
      onClick={scrollToTop}
      className={`back-to-top ${showButton ? "visible" : ""}`}
    >
      <FiCornerRightUp className="icons"/>
    </button>
  );
};

export default BackToTop;
