
import React, { useState, useEffect } from "react";

const BoxReveal = ({ children, boxColor = "#5046e6", duration = 0.5 }) => {
  const [isVisible, setIsVisible] = useState(false);
  const revealRef = React.useRef(null);
  const handleScroll = () => {
    const box = revealRef.current;
    if (box) {
      const rect = box.getBoundingClientRect();
      if (rect.top <= window.innerHeight && rect.bottom >= 0) {
        setIsVisible(true);
      }
    }
  };

  useEffect(() => {
    window.addEventListener("scroll", handleScroll);
    return () => {
      window.removeEventListener("scroll", handleScroll);
    };
  }, []);

  return (
    <div
      ref={revealRef}
      className={`box-reveal ${isVisible ? "reveal" : ""}`}
      style={{
        backgroundColor: boxColor,
        transitionDuration: `${duration}s`,
      }}
    >
      {children}
    </div>
  );
};

export default BoxReveal;
