import { BrowserRouter, Route, Routes } from "react-router-dom";
import { lazy, Suspense ,useEffect} from "react";
import Aos from "aos";
import "./App.css";
import ThemeProvider from "./context/Themecontext";
import Loader from "./components/Loader";
import "aos/dist/aos.css";

const Header = lazy(() => import("./includes/Header"));
const Footer = lazy(() => import("./includes/Footer"));
const HomePage = lazy(() => import("./pages/HomePage"));
const ContactPage = lazy(() => import("./pages/ContactPage"));
const AwardsPage = lazy(() => import("./pages/AwardsPage"));
const EventsPage = lazy(() => import("./pages/EventsPage"));
const FacilitiesPage = lazy(() => import("./pages/Facilitiespage"));
const AboutCodissiaPage = lazy(() => import("./pages/AboutCodissiapage"));
const ArivukkeniPage = lazy(() => import("./pages/ArivukkeniPage"));
const IllakiyaKoodalPage = lazy(() => import("./pages/IllakiyaKoodalPage"));
const BookstallPage = lazy(() => import("./pages/BookstallPage"));
const ErrorPage = lazy(() => import("./pages/ErrorPage"));



function App() {

  useEffect(() => {
    Aos.init({
      duration: 800,
      easing: "ease-in-out",
      once: true,
    });
  }, []);

  return (
    <ThemeProvider>
      <BrowserRouter>
        <Suspense fallback={<Loader />}>
          <Header />
          <Routes>
            <Route path="/" element={<HomePage />} />
            <Route path="/தொடர்புக்கு" element={<ContactPage />} />
            <Route path="/விருதுகள்" element={<AwardsPage />} />
            <Route path="/நிகழ்வுகள்" element={<EventsPage />} />
            <Route path="/கொடிசியா பற்றியது" element={<AboutCodissiaPage />} />
            <Route path="/வசதிகள்" element={<FacilitiesPage />} />
            <Route path="/அறிவுக்கேணி" element={<ArivukkeniPage />} />
            <Route path="/இலக்கியக்கூடல்" element={<IllakiyaKoodalPage />} />
            <Route path="/ஸ்டால் முன்பதிவு" element={<BookstallPage />} />
            <Route path="*" element={<ErrorPage />} />
          </Routes>
          <Footer />
        </Suspense>
      </BrowserRouter>
    </ThemeProvider>
  );
}

export default App;
