import React, { useState, useEffect } from "react";
import {
  Container,
  Grid,
  Card,
  CardMedia,
  Dialog,
  IconButton,
  Box,
} from "@mui/material";
import { motion } from "framer-motion";
import { ArrowBack, ArrowForward, Close, ZoomIn } from "@mui/icons-material";
import apiService, { storage } from "../../services/apiservices";

const Arivukkeni = () => {
  const [isOpen, setIsOpen] = useState(false);
  const [photoIndex, setPhotoIndex] = useState(0);
  const [hoverIndex, setHoverIndex] = useState(null);
  const [galleryData, setGalleryData] = useState([]);
  useEffect(() => {
    const fetchData = async () => {
      try {
        console.log("Fetching arivukkeni data...");
        const response = await apiService.get("arivukkeni");
        const data = response.data;
  
        if (data && Array.isArray(data)) {
          setGalleryData(data);
        } else {
          console.error("Unexpected API response format:", data);
        }
      } catch (error) {
        console.error("Error fetching gallery data:", error);
      }
    };
  
    fetchData();
  }, []);
  
  

  const handleOpen = (index) => {
    setPhotoIndex(index);
    setIsOpen(true);
  };

  const handleClose = () => setIsOpen(false);
  const prevImage = () =>
    setPhotoIndex((photoIndex + galleryData.length - 1) % galleryData.length);
  console.log(galleryData);
  console.log(photoIndex);
  const nextImage = () => setPhotoIndex((photoIndex + 1) % galleryData.length);

  return (
    <Container className="mt-4 mb-4">
      <div className="text-center section-title ">
        <h6 className="mb-3">கோயம்புத்தூர் புத்தகத் திருவிழாவின் ஒரு அங்கமாக புத்தக வாசிப்பு பழக்கத்தை ஊக்குவிக்கும் விதமாக அறிவுக்கேணி என்னும் தளம் செயல் பட்டு வருகிறது.  இதன் மூலமாக பள்ளி, கல்லூரி மாணவர்களிடையே வாசிப்பு பழக்கத்தை ஊக்குவிப்பதற்கான நிகழ்ச்சிகளை ஆண்டு முழுவதும் நடத்தப்பட்டு வருகிறது.  மாணவர்களையும் இளைஞர்களையும்  புத்தகம் நோக்கி கவர்ந்திழுக்கும் விதமாக  கதை சொல்லுதல், புத்தக வாசிப்பு சிறுகதை விமர்சனம், நாவல் வாசிப்பு, நடிப்பு,  ஓரங்க நாடகம், எழுத்தாளர் சந்திப்பு என்று அந்தந்த மாணவர்களுக்கு ஏற்ப நிகழ்ச்சிகள் ஆண்டு முழுவதும் நடத்தப்பட்டு வருகின்றன. </h6>
        <h6> கோயம்புத்தூர் புத்தகத் திருவிழா நடைபெறும் சமயத்தில் பள்ளி கல்லூரி மாணவர்களுக்கான பேச்சுப் போட்டிகள், சிறுகதைப்போட்டி ஆகியன நடத்தப்பட்டு  பரிசுகளும், சான்றிதழ்களும் வழங்கப்பட்டு வருகின்றன.  குழந்தை வாசகர் வட்டம் மற்றும் குழந்தைகளின் வாசிப்பை ஊக்குவிக்கும் விதத்தில் அவர்களுக்கான கதை சொல்லல், விநாடி வினா மற்றும் கதை வாசிப்பு போன்ற நிகழ்ச்சிகள் நடைபெறுகின்றன.  மேலும் பள்ளி கல்லூரி மாணவர்களுக்கான கவியரங்கங்கள், புத்தக வாசிப்பு அரங்கங்கள் தனியாகவும் நடைபெறுகின்றன.</h6>
      </div>
      {/* Image Gallery */}
      <Grid container spacing={3} className="justify-content-center">
        {galleryData.length > 0 ? (
          galleryData.map((src, index) => (
            <Grid item xs={6} sm={6} md={4} key={index}>
              <motion.div
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.5, delay: index * 0.1 }}
                onMouseEnter={() => setHoverIndex(index)}
                onMouseLeave={() => setHoverIndex(null)}
                style={{ position: "relative", cursor: "pointer" }}
              >
                <Card onClick={() => handleOpen(index)}>
                  <CardMedia
                    component="img"
                    height="300"
                    image={`${storage}/${src.images[0]?.image_path}`}

                    alt={`Gallery ${index + 1}`}
                    loading="lazy"
                  />
                  {hoverIndex === index && (
                    <motion.div
                      initial={{ opacity: 0 }}
                      animate={{ opacity: 1 }}
                      transition={{ duration: 0.3 }}
                      style={{
                        position: "absolute",
                        top: 0,
                        left: 0,
                        width: "100%",
                        height: "100%",
                        background: "rgba(0, 0, 0, 0.4)",
                        backdropFilter: "blur(5px)",
                        display: "flex",
                        justifyContent: "center",
                        alignItems: "center",
                        borderRadius: "4px",
                      }}
                    >
                      <ZoomIn sx={{ fontSize: 50, color: "white" }} />
                    </motion.div>
                  )}
                </Card>
              </motion.div>
            </Grid>
          ))
        ) : (
          <div className="no-testimonials">
            <p>No images available</p>
          </div>
        )}
      </Grid>

      {/* Lightbox Dialog */}
      <Dialog fullScreen open={isOpen} onClose={handleClose}>
        <Box
          display="flex"
          justifyContent="center"
          alignItems="center"
          height="100vh"
          position="relative"
          bgcolor="black"
        >
          <IconButton
            onClick={handleClose}
            sx={{ position: "absolute", top: 20, right: 20, color: "white" }}
          >
            <Close sx={{ fontSize: 30 }} />
          </IconButton>
          <IconButton
            onClick={prevImage}
            sx={{ position: "absolute", left: 20, color: "white" }}
          >
            <ArrowBack sx={{ fontSize: 40 }} />
          </IconButton>
          <motion.img
            key={photoIndex}
            src={`${storage}/${galleryData[photoIndex]?.images[0]?.image_path}`}

            alt="Lightbox"
            initial={{ opacity: 0, scale: 0.8 }}
            animate={{ opacity: 1, scale: 1 }}
            transition={{ duration: 0.5, ease: "easeOut" }}
            style={{
              maxWidth: "100%",
              maxHeight: "90vh",
              objectFit: "contain",
              borderRadius: "8px",
            }}
          />
          <IconButton
            onClick={nextImage}
            sx={{ position: "absolute", right: 20, color: "white" }}
          >
            <ArrowForward sx={{ fontSize: 40 }} />
          </IconButton>
        </Box>
      </Dialog>
    </Container>
  );
};

export default React.memo(Arivukkeni);