import React, { useState } from "react";
import axios from "axios";
import Brouchure from "./Brouchure";
import { toast, ToastContainer } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import apiServices from "../services/apiservices";


const toastConfig = {
  position: "top-right",
  autoClose: 3000,
  hideProgressBar: false,
  closeOnClick: true,
  pauseOnHover: true,
  draggable: true,
  theme: "colored",
};

const Bookstall = () => {
  const [name, setName] = useState("");
  const [company, setCompany] = useState("");
  const [email, setEmail] = useState("");
  const [mobile, setMobile] = useState("");
  const [message, setMessage] = useState("");
  const [errors, setErrors] = useState({});

  const handleSubmit = async (e) => {
    e.preventDefault();
    setErrors({});

    try {
      const response = await apiServices.post("submit-stall", {
        name,
        company,
        email,
        mobile,
        message,
      });

      if (response.message) {
        toast.success(response.message, toastConfig);
        setName("");
        setCompany("");
        setEmail("");
        setMobile("");
        setMessage("");
      }
    } catch (error) {
      if (error.response && error.response.data.errors) {
        setErrors(error.response.data.errors);

        Object.values(error.response.data.errors).flat().forEach((msg) => {
          toast.error(msg, toastConfig);
        });
      } else {
        toast.error("சமர்ப்பிக்க முடியவில்லை. பின்னர் முயற்சிக்கவும்.", toastConfig);
      }
    }
  };

  return (
    <section>
      <ToastContainer /> 
      {/* <div className="container booking-form">
        <div className="mt-5 text-center">
          <h5>உங்கள் ஸ்டாலை முன்பதிவு செய்யுங்கள்</h5>
        </div>
        <div className="row justify-content-center">
          <div className="col-md-8">
            <form onSubmit={handleSubmit} className="mt-4 booking-form">
              <div className="row">
                <div className="col-md-6">
                <div className="mb-3">
                <label htmlFor="name" className="form-label">
                  பெயர் <span className="text-danger">*</span>
                </label>
                <input
                  type="text"
                  className="form-control"
                  id="name"
                  placeholder="உங்கள் பெயரை உள்ளிடவும்"
                  value={name}
                  onChange={(e) => setName(e.target.value)}
                />
                {errors.name && <span className="text-danger">{errors.name[0]}</span>}
              </div>
                </div>
                <div className="col-md-6">
                <div className="mb-3">
                <label htmlFor="company" className="form-label">
                  நிறுவனம் <span className="text-danger">*</span>
                </label>
                <input
                  type="text"
                  className="form-control"
                  id="company"
                  placeholder="உங்கள் நிறுவனத்தை உள்ளிடவும்"
                  value={company}
                  onChange={(e) => setCompany(e.target.value)}
                />
                {errors.company && <span className="text-danger">{errors.company[0]}</span>}
              </div>
                </div>
              </div>
            

             

              <div className="row">
                <div className="col-md-6">
                  <div className="mb-3">
                    <label htmlFor="email" className="form-label">
                      மின்னஞ்சல் <span className="text-danger">*</span>
                    </label>
                    <input
                      type="email"
                      className="form-control"
                      id="email"
                      placeholder="உங்கள் மின்னஞ்சலை உள்ளிடவும்"
                      value={email}
                      onChange={(e) => setEmail(e.target.value)}
                    />
                    {errors.email && <span className="text-danger">{errors.email[0]}</span>}
                  </div>
                </div>
                <div className="col-md-6">
                  <div className="mb-3">
                    <label htmlFor="mobile" className="form-label">
                      மொபைல் எண் <span className="text-danger">*</span>
                    </label>
                    <input
                      type="tel"
                      className="form-control"
                      id="mobile"
                      placeholder="உங்கள் மொபைல் எண்ணை உள்ளிடவும்"
                      value={mobile}
                      onChange={(e) => setMobile(e.target.value)}
                    />
                    {errors.mobile && <span className="text-danger">{errors.mobile[0]}</span>}
                  </div>
                </div>
              </div>

              <div className="mb-3">
                <label htmlFor="message" className="form-label">
                  செய்தி 
                </label>
                <textarea
                  className="form-control"
                  id="message"
                  rows="5"
                  placeholder="உங்கள் செய்தியை உள்ளிடவும்"
                  value={message}
                  onChange={(e) => setMessage(e.target.value)}
                ></textarea>
                {errors.message && <span className="text-danger">{errors.message[0]}</span>}
              </div>

              <div className="d-flex justify-content-center mb-3">
                <button type="submit" className="btn booking-form-btn">
                  பதிவு செய்யவும்
                </button>
              </div>
            </form>
          </div>
        </div>
      </div> */}
      <Brouchure />
    </section>
  );
};

export default Bookstall;
