import React, { useContext, useState } from "react";
import { Themecontext } from "../context/Themecontext"; 
import { storage } from "../services/apiservices";
import { Worker, Viewer } from "@react-pdf-viewer/core";
import { defaultLayoutPlugin } from "@react-pdf-viewer/default-layout";
import "@react-pdf-viewer/core/lib/styles/index.css";
import "@react-pdf-viewer/default-layout/lib/styles/index.css";

const Brouchure = () => {
  const { brochures = [] } = useContext(Themecontext);
  const [selectedTab, setSelectedTab] = useState(0);
  const defaultLayoutPluginInstance = defaultLayoutPlugin();

  // Swap first and second brochure
  const reorderedBrochures = [...brochures];
  if (reorderedBrochures.length >= 2) {
    [reorderedBrochures[0], reorderedBrochures[1]] = [reorderedBrochures[1], reorderedBrochures[0]];
  }

  return (
    <div className="container mt-4 mb-5">
    {reorderedBrochures.length > 0 ? (
      <ul className="nav nav-pills justify-content-start mb-3">
        {reorderedBrochures.map((brochure, index) => (
          <li key={brochure.id} className="nav-item">
            <button
              className={`nav-link ${selectedTab === index ? "active" : ""}`}
              onClick={() => setSelectedTab(index)}
            >
              {brochure.name}
            </button>
          </li>
        ))}
      </ul>
    ) : (
      <p className="text-center">No brochures available.</p>
    )}

    {reorderedBrochures.length > 0 && reorderedBrochures[selectedTab] && (
      <div style={{ border: "1px solid #ccc", width: "100%", height: "800px", overflow: "auto" }}>
        <Worker workerUrl="https://unpkg.com/pdfjs-dist@3.11.174/build/pdf.worker.js">
          <Viewer
            fileUrl={`${storage}/${reorderedBrochures[selectedTab].image_path}`}
            plugins={[defaultLayoutPluginInstance]}
          />
        </Worker>
      </div>
    )}
  </div>
);
};
export default Brouchure;
