import React, { useState } from "react";
import codissia from "../../assets/Codissia/codissia.png";
import codissiamain from "../../assets/Codissia/codissia-main.png";

import {
  FaCar,
  FaPlane,
  FaTrain,
  FaRoad,
  FaBuilding,
  FaWifi,
} from "react-icons/fa";

import Fair from "./Fair";

const Aboutcodissia = () => {
  return (
    <div>
      <div className="section-title text-center">
        <h4 className="text-center mt-4" style={{maxWidth: "1400px", margin: "auto"}}>
   
          CODISSIA, established in 1969, is a Non-Profit, ISO 9001-2015
          certified MSME association with 6600+ members, driving industrial
          growth in Coimbatore.{" "}
        </h4>
      </div>
      <div className="container mb-5">
        <div className="row">
          <div className="col-md-6">
            <div className="about-codissia">
              <div className="td_about_year text-uppercase td_fs_64 td_bold">
                CODISSIA
              </div>

              <div className="imgleft">
                <img className="img-fluid" src={codissia} alt="" srcset="" />
              </div>
              <div className="imgright">
                <img
                  className="img-fluid"
                  src={codissiamain}
                  alt=""
                  srcset=""
                />
              </div>
            </div>
          </div>
          <div className="col-md-6">
            <div className="content-heading">
              <p>ABOUT CODISSIA</p>
            </div>
            <div className="about-codissia-info">
              <h4>
                Coimbatore District Small Industries Association (CODISSIA)
              </h4>
              <p>
                The Coimbatore District Small Industries Association popularly
                known as CODISSIA, was established in the year 1969. It is a
                Non-Profit, ISO 9001-2015 certified, one of the largest Business
                Membership Organisation for Micro, Small and Medium Enterprises
                in India. It has a membership of more than 6600 MSME’s from
                different segments. CODISSIA works for Industrial development,
                economic growth and prosperity of Coimbatore region.
              </p>
              <p>
                The Association has made significant contribution towards
                building a strong and stable industrial belt in this region and
                created awareness among entrepreneurs.
              </p>

              <div>
        
              </div>
            </div>
          </div>
        </div>
      </div>
      <Fair/>
      
      <div className="container mb-5 ">
        <div className="row salient-features-info">
          <div className="d-flex">
            <h4>Salient Features of CODISSIA Trade Fair Complex</h4>
          </div>
          <div className="col-md-6">
            <ul>
              <li>
                <FaPlane /> 2 Kms away from the Airport
              </li>
              <li>
                <FaTrain className="ps-2"  /> 6 Kms away from the Railway Station
              </li>
              <li>
                  <FaRoad className="ps-2" /> 1 Km away from NH-47
              </li>
              <li>
                <FaBuilding className="ps-2" /> Systematic and excellent stall layout for high
                visibility
              </li>
              <li>
                <FaBuilding className="ps-2" /> Covered column-free exhibition space of 20,000
                sq.mts
              </li>
            </ul>
          </div>
          <div className="col-md-6">
            <ul>
              <li>
                <FaBuilding className="ps-2" /> Roof height of 10.65 mt for easy handling of
                heavy machineries
              </li>
              <li>
                <FaBuilding className="ps-2" /> Heavy-duty flooring
              </li>
              <li>
                <FaWifi /> Availability of power, water, and pneumatic air
              </li>
              <li>
                <FaCar /> Ample parking space for 2,000 cars and 10,000
                two-wheelers
              </li>
              <li>
                <FaWifi /> Wi-Fi enabled 24-hours communication centre
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  );
};

export default React.memo(Aboutcodissia);
