import React from "react";
import HallA from "../../assets/Codissia/halls/HallA.jpg";
import HallB from "../../assets/Codissia/halls/HallB.jpg";
import HallC from "../../assets/Codissia/halls/HallC.jpg";
import HallD from "../../assets/Codissia/halls/HallD.jpg";
import HallE from "../../assets/Codissia/halls/HallE.jpg";
import Foodcourt from "../../assets/Codissia/facility/Foodcourt.jpg";
import Entrance from "../../assets/Codissia/facility/Entrance.jpg";
import infrastructuremain from "../../assets/Codissia/facility/infrastructure-main.jpg";
import parking from "../../assets/Codissia/facility/parking.jpg";
import Pathway from "../../assets/Codissia/facility/Pathway.jpg";


const Facilities = () => {
  const facilities = [
    { title: "Entrance", img: Entrance },
    { title: "Infrastructure", img: infrastructuremain },
    { title: "Parking", img: parking },
    { title: "Pathway", img: Pathway },


  ];
  const halls = [
    // Halls
    { title: "Hall A", img: HallA },
    { title: "Hall B", img: HallB },
    { title: "Hall C", img: HallC },
    { title: "Hall D", img: HallD },
    { title: "Hall E", img: HallE },
    { title: "Hall F", img: Foodcourt },
  ];
  return (
    <section className="facilities-main">
      <div className="container mt-5">
        <div className="mb-5">
          <div className="content-heading">
            <h2>Our Halls</h2>
          </div>
          <div className="row g-4 justify-content-center">
            {halls.map((facility, index) => (
              <div key={index} className="col-sm-6 col-md-6 col-lg-4">
                <div className="facility-card">
                  <div className="facility-img-container">
                    <img
                      src={facility.img}
                      alt={facility.title}
                      className="facility-img"
                    />
                  </div>
                  <div className="facility-content">
                    <h5>{facility.title}</h5>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
        {/* Facilities */}
        <div>
          <div className="content-heading">
            <h2>Our Facilities</h2>
          </div>
          <div className="row g-4">
            {facilities.map((facility, index) => (
              <div key={index} className="col-sm-6 col-md-6 col-lg-3">
                <div className="facility-card">
                  <div className="facility-img-container">
                    <img
                      src={facility.img}
                      alt={facility.title}
                      className="facility-img"
                    />
                  </div>
                  <div className="facility-content">
                    <h5>{facility.title}</h5>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};

export default React.memo(Facilities);
