import React, { useEffect, useRef } from "react";
import { gsap } from "gsap";
import facility1 from '../../assets/Codissia/infrastructure/1.jpg'
import facility2 from '../../assets/Codissia/infrastructure/2.jpg'
import facility3 from '../../assets/Codissia/infrastructure/3.jpg'
import facility4 from '../../assets/Codissia/infrastructure/4.jpg'
import facility5 from '../../assets/Codissia/infrastructure/5.jpg'


const images = [
  facility1,
  facility2,
  facility3,
  facility4,
  facility5,

];

const BounceGallery = () => {
  const galleryRef = useRef([]);

  useEffect(() => {
    gsap.set(galleryRef.current, {
      rotate: (i) => (i % 2 === 0 ? -10 : 10), 
      opacity: 0,
      y: 50,
    });

    gsap.to(galleryRef.current, {
      opacity: 1,
      y: 0,
      rotate: (i) => (i % 2 === 0 ? -10 : 10),
      duration: 1,
      stagger: 0.15,
      ease: "elastic.out(1, 0.5)",
    });
  }, []);

  return (
    <div className="gallery-container">
      <div>
       
      </div>
      {images.map((src, index) => (
        <div
          key={index}
          className="gallery-item"
          ref={(el) => (galleryRef.current[index] = el)}
          onMouseEnter={() => gsap.to(galleryRef.current[index], { rotate: 0, duration: 0.3 })}
          onMouseLeave={() =>
            gsap.to(galleryRef.current[index], {
              rotate: index % 2 === 0 ? -10 : 10,
              duration: 0.5,
              ease: "power1.out",
            })
          }
        >
          <img src={src} alt={`Image ${index + 1}`} />
        </div>
      ))}
    </div>
  );
};

export default React.memo(BounceGallery);
