import React, { useState } from "react";
import {
  Box,
  Tab,
  Tabs,
  useMediaQuery,
  useTheme,
  Accordion,
  AccordionSummary,
  AccordionDetails,
  Typography,
} from "@mui/material";
import { FaInfoCircle } from "react-icons/fa";
import { IoLocationOutline } from "react-icons/io5";
import { SiVfairs } from "react-icons/si";
import fair1 from "../../assets/about/fair/1.jpg";
import fair2 from "../../assets/about/fair/2.jpg";
import fair3 from "../../assets/about/fair/3.jpg";
import fair4 from "../../assets/about/fair/4.jpg";
import venue1 from "../../assets/about/venue/1.jpg";
import venue2 from "../../assets/about/venue/2.jpg";
import venue3 from "../../assets/about/venue/3.jpg";
import city from "../../assets/about/city/city.png";
import csf from "../../assets/about/others/csf.png";
import intec from "../../assets/about/others/intec.png";
import agriintex from "../../assets/about/others/agri.png";
import buildintec from "../../assets/about/others/buildintec.png";
import elektrotec from "../../assets/about/others/elektrotec.png";
import rawmat from "../../assets/about/others/rm.png";
import { PiCityThin } from "react-icons/pi";
import { TiInfoLarge } from "react-icons/ti";

const Fair = () => {
  const [value, setValue] = useState(0);
  const images = [
    { src: csf, alt: "CSF", href: "https://csf.codissia.com/" },
    { src: agriintex, alt: "Agri", href: "https://agriintex.codissia.com/" },
    { src: intec, alt: "INTEC", href: "https://www.intec.codissia.com/" },
    { src: buildintec, alt: "BUILDINTEC", href: "https://www.buildintec.codissia.com/" },
    {
      src: elektrotec,
      alt: "Elektrotec",
      href: "https://www.elektrotec.codissia.com/",
    },
    { src: rawmat, alt: "Raw Mat", href: "https://rawmat.codissia.com/" },
  ];

  const handleChange = (event, newValue) => {
    setValue(newValue);
  };

  const theme = useTheme();
  const isMobile = useMediaQuery(theme.breakpoints.down("sm"));

  return (
    <div className="container">
      <Box className="custom-tabs-container">
        <Tabs
          value={value}
          onChange={handleChange}
          aria-label="custom styled tabs"
          className="custom-tabs d-none d-sm-block "
          centered
        >
          <Tab label="Fair" className="custom-tab" />
          <Tab label="Venue" className="custom-tab" />
          <Tab label="City" className="custom-tab" />
          <Tab label="Other Fairs" className="custom-tab" />
        </Tabs>

        <Box className="custom-tab-content">
          {isMobile ? (
            // Mobile Accordion View
            <>
              <Accordion expanded={value === 0} onChange={() => setValue(0)}>
                <AccordionSummary>
                  <Typography>
                    {" "}
                    <SiVfairs /> Fair
                  </Typography>
                </AccordionSummary>
                <AccordionDetails>
                  <p>
                    <strong>Build Intec</strong> is set to celebrate its{" "}
                    <strong>14th Edition</strong>, one of the largest
                    exhibitions in South India...
                  </p>
                  <div className="row">
                    <div className="col-md-6 col-6 d-flex justify-content-center">
                      <img className="img-fluid mb-3" src={fair1} alt="fair1" />
                    </div>
                    <div className="col-md-6 col-6 d-flex justify-content-center">
                      <img className="img-fluid mb-3" src={fair2} alt="fair2" />
                    </div>
                    <div className="col-md-6 col-6 d-flex justify-content-center">
                      <img className="img-fluid mb-3" src={fair3} alt="fair3" />
                    </div>
                    <div className="col-md-6 col-6 d-flex justify-content-center">
                      <img className="img-fluid mb-3" src={fair4} alt="fair4" />
                    </div>
                  </div>
                </AccordionDetails>
              </Accordion>

              <Accordion expanded={value === 1} onChange={() => setValue(1)}>
                <AccordionSummary>
                  <Typography>
                    {" "}
                    <IoLocationOutline /> Venue
                  </Typography>
                </AccordionSummary>
                <AccordionDetails>
                  <div className="row">
                    <div className="col-lg-4 col-md-6 col-6">
                      <img
                        className="img-fluid mb-3"
                        src={venue1}
                        alt="venue1"
                      />
                    </div>
                    <div className="col-lg-4 col-md-6 col-6">
                      <img
                        className="img-fluid mb-3"
                        src={venue2}
                        alt="venue2"
                      />
                    </div>
                    <div className="col-lg-4 col-md-6 col-6">
                      <img
                        className="img-fluid mb-3"
                        src={venue3}
                        alt="venue3"
                      />
                    </div>
                  </div>
                  <div className="row">
                    <div>
                      <div className="venue-heading mb-3 mt-5">
                        <h4>Salient Features</h4>
                      </div>
                      <div className="features-container">
                        <div className="row">
                          <div className="col-md-6">
                            <div className="feature-column">
                              <ul>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>
                                    Proximity to Airport, Railway Station &
                                    National Highway
                                  </p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>2 kms away from the Airport</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>6 kms away from the Railway Station</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>1 km away from NH47</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>
                                    Covered column-free exhibition space of
                                    20,000 sq. mts
                                  </p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Minimum roof height of 10.65 mts</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Open air display area of 50,000 sq. mts</p>
                                </li>
                              </ul>
                            </div>
                          </div>

                          <div className="col-md-6">
                            <div className="feature-column">
                              <ul>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Heavy-duty flooring</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>
                                    Availability of power, water, and pneumatic
                                    air
                                  </p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>
                                    Systematic and excellent stall layout for
                                    high visibility
                                  </p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>
                                    Conference halls and demonstration
                                    facilities
                                  </p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>
                                    Ample parking space for 2,000 cars and
                                    10,000 two-wheelers
                                  </p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Wi-Fi 24-hour communication center</p>
                                </li>
                              </ul>
                            </div>
                          </div>
                        </div>
                      </div>

                      {/* Venue Specifications */}
                      <div className="mb-3">
                        <div className="venue-heading mb-3">
                          <h4>Venue Specifications</h4>
                        </div>
                        <div className="row">
                          <div className="col-md-6">
                            <div className="feature-column">
                              <h6>HALL – A & C</h6>
                              <ul>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Exhibition Area – 2,500 sq.mts. each</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Roof Height – 6 mts.</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Flooring – Heavy Duty</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>
                                    Material Entry Gate – 4.6m width * 5m height
                                  </p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Air-Conditioned</p>
                                </li>
                              </ul>
                            </div>
                          </div>

                          <div className="col-md-6">
                            <div className="feature-column">
                              <h6>HALL – B</h6>
                              <ul>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Exhibition Area – 5,000 sq.mts.</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Roof Height – 10.65mts.</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Flooring – Heavy Duty</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>
                                    Material Entry Gate – 4.6m width * 5m height
                                  </p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Air-Conditioned</p>
                                </li>
                              </ul>
                            </div>
                          </div>
                        </div>
                      </div>

                      {/* Hall Details 2 */}
                      <div className="row">
                        <div className="col-md-6">
                          <div className="feature-column">
                            <h6> HALL – D</h6>
                            <ul>
                              <li>
                                <span>
                                  <FaInfoCircle />
                                </span>
                                <p>Exhibition Area – 5,000 sq.mts.</p>
                              </li>
                              <li>
                                <span>
                                  <FaInfoCircle />
                                </span>
                                <p>Roof Height – 10.65 mts.</p>
                              </li>
                              <li>
                                <span>
                                  <FaInfoCircle />
                                </span>
                                <p>
                                  Material Entry Gate – 4.6m width * 5m height
                                </p>
                              </li>
                              <li>
                                <span>
                                  <FaInfoCircle />
                                </span>
                                <p>Air-Conditioned</p>
                              </li>
                            </ul>
                          </div>
                        </div>

                        <div className="col-md-6">
                          <div className="feature-column">
                            <h6>HALL – E</h6>
                            <ul>
                              <li>
                                <span>
                                  <FaInfoCircle />
                                </span>
                                <p>Exhibition Area – 4,000 sq.mts.</p>
                              </li>
                              <li>
                                <span>
                                  <FaInfoCircle />
                                </span>
                                <p>Ceiling Height – 6m</p>
                              </li>
                              <li>
                                <span>
                                  <FaInfoCircle />
                                </span>
                                <p>Only for Light Exhibits</p>
                              </li>
                              <li>
                                <span>
                                  <FaInfoCircle />
                                </span>
                                <p>Air-Conditioned</p>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </AccordionDetails>
              </Accordion>

              <Accordion expanded={value === 2} onChange={() => setValue(2)}>
                <AccordionSummary>
                  <Typography>
                    {" "}
                    <PiCityThin /> City
                  </Typography>
                </AccordionSummary>
                <AccordionDetails>
                  <div className="row">
                    <div className="col-lg-12">
                      <div className="d-flex justify-content-center mb-3">
                        <img className="img-fluid mb-3" src={city} alt="city" />
                      </div>
                    </div>
                  </div>
                  <div className="col-lg-12">
                    <div>
                      <div className="mb-2">
                        <h5>
                          Significance of Coimbatore Book Festival at Coimbatore
                        </h5>
                      </div>
                      <ul>
                        <li>
                          <FaInfoCircle size={20} />
                          Coimbatore is the second largest city in Tamil Nadu
                          and the fastest growing Tier-II city
                        </li>
                        <li>
                          <FaInfoCircle size={20} /> Urbanisation is on the rise
                          - An opportunity for the construction industry.
                        </li>
                        <li>
                          <FaInfoCircle size={20} /> Real Estate sector in the
                          boom phase.
                        </li>
                        <li>
                          <FaInfoCircle size={20} />
                          Rapid infra structural growth- elevated expressways,
                          major flyovers, ring roads
                        </li>
                        <li>
                          <FaInfoCircle size={20} />
                          Growth in residents - Gaining 'cosmopolitan' nature
                        </li>
                        <li>
                          <FaInfoCircle size={20} />
                          Metro rail and other infra structural projects on the
                          anvil.
                        </li>
                        <li>
                          <FaInfoCircle size={20} />
                          PSUs eyeing Combatore region for setting up new
                          projects.
                        </li>
                        <li>
                          <FaInfoCircle size={20} />
                          Proximity to neighbouring states - Kerala & Karnataka.
                        </li>
                        <li>
                          <FaInfoCircle size={20} />
                          Excellent connectivity by air, rail and road.
                        </li>
                      </ul>
                    </div>
                  </div>
                </AccordionDetails>
              </Accordion>

              <Accordion expanded={value === 3} onChange={() => setValue(3)}>
                <AccordionSummary>
                  <Typography>
                    {" "}
                    <TiInfoLarge /> Other Fairs
                  </Typography>
                </AccordionSummary>
                <AccordionDetails>
                  <div className="others-fair">
                    <div className="row">
                      {images.map((image, index) => (
                        <div
                          key={index}
                          className="col-lg-4 col-md-6 col-6 mb-2 d-flex justify-content-center align-items-center"
                        >
                          <a
                            href={image.href}
                            target="_blank"
                            rel="noopener noreferrer"
                          >
                            <img
                              className="img-fluid"
                              src={image.src}
                              alt={image.alt}
                            />
                          </a>
                        </div>
                      ))}
                    </div>
                  </div>
                </AccordionDetails>
              </Accordion>
            </>
          ) : (
            // Desktop Tab View
            <>
              {value === 0 && (
                <div className="tab-content-item mt-4">
                  <div>
                    <div>
                      <p>
                        <span>
                          <strong>Coimbatore Book Festival </strong>
                        </span>
                        is set to celebrate its <strong>9th Edition</strong>,
                        one of the largest literary festivals in South India,
                        bringing together authors, publishers, and book
                        enthusiasts from across the nation. Over the years, the
                        festival has received overwhelming support from the
                        literary community, with a focus on promoting reading
                        culture and knowledge sharing.
                      </p>
                      <p>
                        Backed by leading publishing houses, participation from
                        renowned national and international authors, and
                        extensive media coverage, the event has established
                        itself as a prominent platform for literary engagement.
                      </p>
                      <p>
                        CODISSIA invites{" "}
                        <strong> publishers, authors, and book lovers </strong>
                        to be part of this grand celebration of literature,
                        showcasing their works and connecting with a passionate
                        audience in this vibrant literary hub.
                      </p>
                    </div>

                    <div className="row">
                      <div className="col-md-6">
                        <img
                          className="img-fluid mb-3"
                          src={fair1}
                          alt="fair1"
                        />
                      </div>
                      <div className="col-md-6">
                        <img
                          className="img-fluid mb-3"
                          src={fair2}
                          alt="fair2"
                        />
                      </div>
                      <div className="col-md-6">
                        <img
                          className="img-fluid mb-3"
                          src={fair3}
                          alt="fair3"
                        />
                      </div>
                      <div className="col-md-6">
                        <img
                          className="img-fluid mb-3"
                          src={fair4}
                          alt="fair4"
                        />
                      </div>
                    </div>
                  </div>
                </div>
              )}
              {value === 1 && (
                <div className="tab-content-item mt-4">
                  <div>
                    <div className="row">
                      <div className="col-lg-4">
                        <img
                          className="img-fluid mb-3"
                          src={venue1}
                          alt="venue1"
                        />
                      </div>
                      <div className="col-lg-4">
                        <img
                          className="img-fluid mb-3"
                          src={venue2}
                          alt="venue2"
                        />
                      </div>
                      <div className="col-lg-4">
                        <img
                          className="img-fluid mb-3"
                          src={venue3}
                          alt="venue3"
                        />
                      </div>
                    </div>
                    <div className="row">
                      <div>
                        <div className="venue-heading mb-3 mt-5">
                          <h4>Salient Features</h4>
                        </div>
                        <div className="features-container">
                          <div className="row">
                            <div className="col-md-6">
                              <div className="feature-column">
                                <ul>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>
                                      Proximity to Airport, Railway Station &
                                      National Highway
                                    </p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>2 kms away from the Airport</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>6 kms away from the Railway Station</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>1 km away from NH47</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>
                                      Covered column-free exhibition space of
                                      20,000 sq. mts
                                    </p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Minimum roof height of 10.65 mts</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>
                                      Open air display area of 50,000 sq. mts
                                    </p>
                                  </li>
                                </ul>
                              </div>
                            </div>

                            <div className="col-md-6">
                              <div className="feature-column">
                                <ul>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Heavy-duty flooring</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>
                                      Availability of power, water, and
                                      pneumatic air
                                    </p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>
                                      Systematic and excellent stall layout for
                                      high visibility
                                    </p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>
                                      Conference halls and demonstration
                                      facilities
                                    </p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>
                                      Ample parking space for 2,000 cars and
                                      10,000 two-wheelers
                                    </p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Wi-Fi 24-hour communication center</p>
                                  </li>
                                </ul>
                              </div>
                            </div>
                          </div>
                        </div>

                        {/* Venue Specifications */}
                        <div className="mb-3">
                          <div className="venue-heading mb-3">
                            <h4>Venue Specifications</h4>
                          </div>
                          <div className="row">
                            <div className="col-md-6">
                              <div className="feature-column">
                                <h6>HALL – A & C</h6>
                                <ul>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Exhibition Area – 2,500 sq.mts. each</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Roof Height – 6 mts.</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Flooring – Heavy Duty</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>
                                      Material Entry Gate – 4.6m width * 5m
                                      height
                                    </p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Air-Conditioned</p>
                                  </li>
                                </ul>
                              </div>
                            </div>

                            <div className="col-md-6">
                              <div className="feature-column">
                                <h6>HALL – B</h6>
                                <ul>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Exhibition Area – 5,000 sq.mts.</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Roof Height – 10.65mts.</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Flooring – Heavy Duty</p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>
                                      Material Entry Gate – 4.6m width * 5m
                                      height
                                    </p>
                                  </li>
                                  <li>
                                    <span>
                                      <FaInfoCircle />
                                    </span>
                                    <p>Air-Conditioned</p>
                                  </li>
                                </ul>
                              </div>
                            </div>
                          </div>
                        </div>

                        {/* Hall Details 2 */}
                        <div className="row">
                          <div className="col-md-6">
                            <div className="feature-column">
                              <h6>HALL – D</h6>
                              <ul>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Exhibition Area – 5,000 sq.mts.</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Roof Height – 10.65 mts.</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>
                                    Material Entry Gate – 4.6m width * 5m height
                                  </p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Air-Conditioned</p>
                                </li>
                              </ul>
                            </div>
                          </div>

                          <div className="col-md-6">
                            <div className="feature-column">
                              <h6>HALL – E</h6>
                              <ul>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Exhibition Area – 4,000 sq.mts.</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Ceiling Height – 6m</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Only for Light Exhibits</p>
                                </li>
                                <li>
                                  <span>
                                    <FaInfoCircle />
                                  </span>
                                  <p>Air-Conditioned</p>
                                </li>
                              </ul>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              )}
              {value === 2 && (
                <div className="tab-content-item mt-4">
                  <div className="row">
                    <div className="col-lg-12">
                      <div className="d-flex justify-content-center mb-3">
                        <img
                          className="img-fluid mb-3"
                          style={{ width: "500px" }}
                          src={city}
                          alt="city"
                        />
                      </div>
                    </div>
                  </div>
                  <div className="col-lg-12">
                    <div>
                      <div className="mb-2">
                        <h5>
                          Significance of Coimbatore Book Festival at Coimbatore
                        </h5>
                      </div>
                      <div>
                        <ul>
                          <li>
                            <FaInfoCircle size={20} />
                            Coimbatore is the second largest city in Tamil Nadu
                            and the fastest growing Tier-II city
                          </li>
                          <li>
                            <FaInfoCircle size={20} /> Urbanisation is on the
                            rise - An opportunity for the construction industry.
                          </li>
                          <li>
                            <FaInfoCircle size={20} /> Real Estate sector in the
                            boom phase.
                          </li>
                          <li>
                            <FaInfoCircle size={20} />
                            Rapid infra structural growth- elevated expressways,
                            major flyovers, ring roads
                          </li>
                          <li>
                            <FaInfoCircle size={20} />
                            Growth in residents - Gaining 'cosmopolitan' nature
                          </li>
                          <li>
                            <FaInfoCircle size={20} />
                            Metro rail and other infra structural projects on
                            the anvil.
                          </li>
                          <li>
                            <FaInfoCircle size={20} />
                            PSUs eyeing Combatore region for setting up new
                            projects.
                          </li>
                          <li>
                            <FaInfoCircle size={20} />
                            Proximity to neighbouring states - Kerala &
                            Karnataka.
                          </li>
                          <li>
                            <FaInfoCircle size={20} />
                            Excellent connectivity by air, rail and road.
                          </li>
                        </ul>
                      </div>
                    </div>
                  </div>
                </div>
              )}
              {value === 3 && (
                <div className="tab-content-item mt-4 mt-4">
                  <div className="others-fair">
                    <div className="row">
                      {images.map((image, index) => (
                        <div
                          key={index}
                          className="col-lg-4 col-md-6 mb-2 d-flex justify-content-center align-items-center "
                        >
                          <div className="fairs-img">
                            <a
                              href={image.href}
                              target="_blank"
                              rel="noopener noreferrer"
                            >
                              <img
                                className="img-fluid"
                                src={image.src}
                                alt={image.alt}
                              />
                            </a>
                          </div>
                        </div>
                      ))}
                    </div>
                  </div>
                </div>
              )}
            </>
          )}
        </Box>
      </Box>
    </div>
  );
};

export default React.memo(Fair);
