import React, { useState } from "react";

import { ToastContainer, toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import apiServices from "../../services/apiservices";

const ContactForm =()=> {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    mobile: "",
    message: "",
  });

  const [formErrors, setFormErrors] = useState({});

  const handleChange = (e) => {
    const { name, value } = e.target;
    setFormData((prev) => ({
      ...prev,
      [name]: value,
    }));

    setFormErrors((prev) => ({
      ...prev,
      [name]: "",
    }));
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    setFormErrors({}); 

    try {
      const res = await apiServices.post(
        "contact-form",
        formData
      );
    toast.success(res.message || "Form submitted successfully!");
      setFormData({ name: "", email: "", mobile: "", message: "" });
    } catch (err) {
      if (err.response?.data?.errors) {
        const errors = err.response.data.errors;

        const newErrors = {};
        if (errors.name) newErrors.name = errors.name[0];
        if (errors.email) newErrors.email = errors.email[0];
        if (errors.mobile || errors.mobile)
          newErrors.mobile = errors.mobile?.[0] || errors.mobile?.[0];
        if (errors.message) newErrors.message = errors.message[0];

        setFormErrors(newErrors);
      } else {
        toast.error("Something went wrong. Please try again.");
        console.log("Full error response:", err.response);

        
      }
    }
  };

  return (
    <div>
      <ToastContainer position="top-right" autoClose={3000} />
      <div className="cool-contact-container container py-5">
        <div className="row justify-content-center cool-contact-container-main">
          <div className="col-md-1"></div>
          <div className="col-md-10 col-lg-8">
            <div className="cool-contact-card p-4">
              <h4 className="mb-4">Enquiry Us</h4>
              <form onSubmit={handleSubmit}>
                <div className="mb-3">
                  <label className="form-label">பெயர்</label>
                  <input
                    type="text"
                    name="name"
                    className="form-control"
                    placeholder="உங்கள் பெயரை உள்ளிடவும்"
                    value={formData.name}
                    onChange={handleChange}
                  />
                  {formErrors.name && (
                    <span className="text-danger">{formErrors.name}</span>
                  )}
                </div>

                <div className="row">
                  <div className="col-md-6">
                    <div className="mb-3">
                      <label className="form-label">மின்னஞ்சல்</label>
                      <input
                        type="email"
                        name="email"
                        className="form-control"
                        placeholder="உங்கள் மின்னஞ்சலை உள்ளிடவும்"
                        value={formData.email}
                        onChange={handleChange}
                      />
                      {formErrors.email && (
                        <span className="text-danger">{formErrors.email}</span>
                      )}
                    </div>
                  </div>
                  <div className="col-md-6">
                    <div className="mb-3">
                      <label className="form-label"> மொபைல் எண்</label>
                      <input
                        type="text"
                        name="mobile"
                        className="form-control"
                        placeholder="உங்கள் மொபைல் எண்ணை உள்ளிடவும்"
                        value={formData.mobile}
                        onChange={handleChange}
                      />
                      {formErrors.mobile && (
                        <span className="text-danger">{formErrors.mobile}</span>
                      )}
                    </div>
                  </div>
                </div>

                <div className="mb-3">
                  <label className="form-label">செய்தி</label>
                  <textarea
                    className="form-control"
                    name="message"
                    rows="4"
                        placeholder="உங்கள் செய்தியை உள்ளிடவும்"
                    value={formData.message}
                    onChange={handleChange}
                  ></textarea>
                  {formErrors.message && (
                    <span className="text-danger">{formErrors.message}</span>
                  )}
                </div>

                <div className="d-flex justify-content-center">
                  <button type="submit" className="btn btn-border-4">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
          <div className="col-md-1"></div>
        </div>
      </div>
    </div>
  );
}

export default React.memo(ContactForm)