import React, { useEffect, useState } from "react";

const Map = () => {
  const [isVisible, setIsVisible] = useState(false);

  useEffect(() => {
    setTimeout(() => {
      setIsVisible(true);
    }, 500);
  }, []);

  return (
    <div className={`map-container ${isVisible ? "fade-in" : ""}`}>
      <div className="container-fluid">
        <div className="row">
          <div className="col-md-12 col-12">
            <div className="map-frame-contact">
              <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4416.216592372581!2d76.97185201111355!3d11.00407388911367!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ba859afecdad2b7%3A0x592a819d88ee6c05!2sGD%20Naidu%20Towers%2C%20Gopalapuram%2C%20Coimbatore%2C%20Tamil%20Nadu%20641018%2C%20India!5e1!3m2!1sen!2sus!4v1740480262064!5m2!1sen!2sus"
                width="100%"
                height="100%"
                allowFullScreen
                loading="lazy"
                referrerPolicy="no-referrer-when-downgrade"
                className=""
              ></iframe>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default React.memo(Map);
