import React from "react";
import { Container, Row, Col } from "react-bootstrap";
import { FaPhoneAlt, FaMapMarkerAlt, FaEnvelope } from "react-icons/fa";


const TravelSection = () => {
 
  return (
    <div>
      <div></div>
      <section className="travel-section mt-5">
        <Container>
          <Row className="align-items-center">
            <Col md={5} className="travel-image-container">
              <div className="map-frame-contact">
                <iframe
                  src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4416.216592372581!2d76.97185201111355!3d11.00407388911367!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ba859afecdad2b7%3A0x592a819d88ee6c05!2sGD%20Naidu%20Towers%2C%20Gopalapuram%2C%20Coimbatore%2C%20Tamil%20Nadu%20641018%2C%20India!5e1!3m2!1sen!2sus!4v1740480262064!5m2!1sen!2sus"
                  width="100%"
                  height="100%"
                  allowFullScreen
                  loading="lazy"
                  referrerPolicy="no-referrer-when-downgrade"
                  className=""
                ></iframe>
              </div>
            </Col>

            <Col md={7} className="travel-content">
              <div className="travel-content-container">
                <h6 className="callback-text">எங்களை அணுகவும்</h6>
                <h2 className="travel-heading">மேலும் தகவலுக்கு எங்களை தொடர்பு கொள்ளுங்கள்</h2>

                {/* Stats */}
                <Row className="travel-stats justify-content-center">
                  <Col xs={12} sm={6} md={12} lg={4} className="stats-box">
                    <div className="icon-stats">
                      <FaPhoneAlt />
                    </div>
                    <h4>தொடர்பு எண்</h4>
                    <p>+91 887 05 06 333</p>
                  </Col>
                  <Col xs={12} sm={6} md={12} lg={4} className="stats-box">
                    <div className="icon-stats">
                      <FaMapMarkerAlt />
                    </div>
                    <h4>முகவரி</h4>
                    <p>
                    கொடிசியா தொழில்காட்சி வளாகம்,, ஜி.வி. கண்காட்சி மைதானம், 
                      அவிநாசி சாலை, கோயம்புத்தூர் – 641014, தமிழ்நாடு, இந்தியா.
                    </p>
                  </Col>

                  <Col xs={12} sm={6} md={12} lg={4} className="stats-box">
                    <div className="icon-stats">
                      <FaEnvelope />
                    </div>
                    <h4>மின்னஞ்சல்</h4>
                    <p>cbf@codissia.com</p>
                  </Col>
                </Row>

                {/* Emergency Call */}
                <div className="emergency-call">
                  <i className="fas fa-phone"></i>
                  <span>எந்தவொரு விசாரணைக்கும் எங்களை அணுகுங்கள்!</span>
                  <h4 className="call-number">தொடர்பு எண்: +91 88705 06333</h4>
                </div>
              </div>
            </Col>
          </Row>
        </Container>
      </section>
    </div>
  );
};

export default React.memo(TravelSection);
