import React, { useState } from "react";
import iconic from "../../assets/Home/authors/bg.gif";
import bharathiyar from "../../assets/Home/authors/bharathiyar.png";
import jayakantham from "../../assets/Home/authors/jayakanthan.png";
import kalki from "../../assets/Home/authors/kalki.png";
import sujatha from "../../assets/Home/authors/sujatha.png";
import vaikom from "../../assets/Home/authors/vaikom.png";

const authors = [
  {
    name: "Bharathiyar",
    image: bharathiyar,
    des: "Bharathiyar was a revolutionary Tamil poet and freedom fighter known for his powerful nationalist and feminist poetry. His works inspired generations of Tamilians..",
    quote: "Our eyes shall never sleep, just like the sun that keeps shining.",
  },
  {
    name: "Jayakantham",
    image: jayakantham,
    des: "Jayakanthan was a legendary Tamil novelist and short story writer known for his deep exploration of human emotions and societal issues. He won several prestigious awards, including the Jnanpith Award.",
    quote: "Only humans can change society.",
  },
  {
    name: "Kalki",
    image: kalki,
    des: "Kalki was a celebrated Tamil novelist, known for his historical novels like Ponniyin Selvan and Sivagamiyin Sabatham. His works beautifully blend history, adventure, and romance.",
    quote: "Love and bravery are the two eyes of human life.",
  },
  {
    name: "Sujatha",
    image: sujatha,
    des: "Sujatha (Rangarajan) was a prolific Tamil writer known for his science fiction, detective stories, and modern literature. His works had a significant impact on Tamil readers, and he was also a scriptwriter for Tamil films.",
    quote: "Beauty is secondary; intelligence is the priority.",
  },
  {
    name: "Vaikom",
    image: vaikom,
    des: "Though he wrote in Malayalam, Basheer’s works were widely loved in Tamil Nadu. He was known for his simple yet profound storytelling that depicted real-life struggles and emotions.",
    quote: "Life has no taste without love.",
  },
];

const Authorsscreen = () => {
  const [activeIndex, setActiveIndex] = useState(0);

  return (
    <div className="author-section">
      <section className="section-padding">
        <div className="custom-carousel-container">
          {/* Tab Links */}
          <ul className="custom-author-tabs">
            {authors.map((author, index) => (
              <li
                key={index}
                className={`custom-tab-link ${
                  index === activeIndex ? "custom-active" : ""
                }`}
                onClick={() => setActiveIndex(index)}
              >
                {author.name}
              </li>
            ))}
          </ul>
          <div className="container">
            <div className="row">
              <div className="col-md-6 d-flex justify-content-end align-items-center">
                <div className="custom-carousel">
                  <div className="custom-carousel-slide">
                    <img
                      src={authors[activeIndex].image}
                      alt={authors[activeIndex].name}
                      className="custom-carousel-image img-fluid"
                    />
                  </div>
                </div>
              </div>
              <div className="col-md-6 d-flex justify-content-center align-items-center">
                <div className="custom-carousel-quote">
                  <p>{authors[activeIndex].des}</p>
                  <p>{authors[activeIndex].quote}</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
   
    </div>
  );
};

export default Authorsscreen;
