import React, { useContext } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import { Themecontext } from "../../context/Themecontext";
import { storage } from "../../services/apiservices";


const Bannerslider = () => {
  const { banner } = useContext(Themecontext);

  if (!banner || banner.length === 0) {
    return <p>Loading banners...</p>;
  }

  return (
    <div className="swiper-container">
      <Swiper
        modules={[Navigation, Pagination, Autoplay]}
        spaceBetween={10}
        slidesPerView={1}
        loop={true}
        dots={false}
        autoplay={{ delay: 5000, disableOnInteraction: false }}
        navigation={{ clickable: true }}
        pagination={{ clickable: true }}
        className="swiper-slider"
      >
        {banner.map((slide) => (
          <SwiperSlide key={slide.id} className="swiper-slide">
            <img
              src={`${storage}/${slide.image_path}`}
              alt={slide.name || `Slide ${slide.id}`}
              className="swiper-image"
            />
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
};

export default Bannerslider;
