import React from "react";
import { storage } from "../../services/apiservices";

const HorizontalScrolling = ({ events }) => {
  return (
    <div className="marquee-container" data-aos="fade-up" data-aos-delay="100">
      <div className="marquee-slider mb-2">
        {events.concat(events).map((img, index) => (
          <div
            key={index}
            className="marquee-item"
            data-aos="zoom-in"
            data-aos-delay={150 + (index % events.length) * 50}
          >
            <img
              src={`${storage}/${img.image_path}`}
              alt={`Event ${(index % events.length) + 1}`}
              className="img-fluid"
              loading="lazy"
            />
          </div>
        ))}
      </div>
      <div className="marquee-slider marqueeScroll-down mb-2">
        {events.concat(events).map((img, index) => (
          <div
            key={`middle-${index}`}
            className="marquee-item"
            data-aos="zoom-in"
            data-aos-delay={200 + (index % events.length) * 50}
          >
            <img
              src={`${storage}/${img.image_path}`}
              alt={`Event ${(index % events.length) + 1}`}
              className="img-fluid"
              loading="lazy"
            />
          </div>
        ))}
      </div>
      <div className="marquee-slider">
        {events.concat(events).map((img, index) => (
          <div
            key={`bottom-${index}`}
            className="marquee-item"
            data-aos="zoom-in"
            data-aos-delay={250 + (index % events.length) * 50}
          >
            <img
              src={`${storage}/${img.image_path}`}
              alt={`Event ${(index % events.length) + 1}`}
              className="img-fluid"
              loading="lazy"
            />
          </div>
        ))}
      </div>
    </div>
  );
};

export default HorizontalScrolling;
