import React, { useState, useRef } from "react";
import { storage } from "../../services/apiservices";
import video from '../../assets/Events/events.mp4';
import iconic from "../../assets/Home/authors/bg.gif";

const Horizontalslider = ({ events }) => {
  const [currentIndex, setCurrentIndex] = useState(0);
  const [showVideo, setShowVideo] = useState(false);
  const [isPlaying, setIsPlaying] = useState(false);
  const videoRef = useRef(null);

  const videoPlaceholder = video;

  // Limit to a maximum of 5 photos
  const images = events && events.length > 0 
    ? events.slice(0, 5).map(event => `${storage}/${event.image_path}`) 
    : [];

  const goToSlide = (index) => {
    setCurrentIndex(index);
    setShowVideo(false);
    setIsPlaying(false);
  };

  const toggleVideo = () => {
    if (videoRef.current) {
      if (isPlaying) {
        videoRef.current.pause();
      } else {
        videoRef.current.play();
      }
      setIsPlaying(!isPlaying);
    } else {
      setShowVideo(true);
      setIsPlaying(true);
    }
  };

  return (
    <div className="custom-slider-container">
  
      <div className="custom-slider mt-4">
        {showVideo ? (
          <video
            ref={videoRef}
            width="100%"
            height="400"
            controls
            onPlay={() => setIsPlaying(true)}
            onPause={() => setIsPlaying(false)}
          >
            <source src={videoPlaceholder} type="video/mp4" />
            Your browser does not support the video tag.
          </video>
        ) : (
          images.length > 0 ? (
            <img
              src={images[currentIndex]}
              alt={`Slide ${currentIndex + 1}`}
              onClick={() => setShowVideo(true)}
            />
          ) : (
            <p>No images available</p>
          )
        )}

        {images.length > 0 && (
          <button className="custom-play-button" onClick={toggleVideo}>
            {isPlaying ? <span>❚❚</span> : <span>▶</span>}
          </button>
        )}
      </div>

      <div className="custom-pagination">
        {images.map((_, index) => (
          <span
            key={index}
            className={`custom-page-number ${index === currentIndex ? "custom-active" : ""}`}
            onClick={() => goToSlide(index)}
          >
            {index + 1}
          </span>
        ))}
      </div>
    </div>
  );
};

export default Horizontalslider;
