import React, { useState, useEffect } from "react";
import { Dialog, DialogContent, IconButton } from "@mui/material";
import CloseIcon from "@mui/icons-material/Close";
import { motion } from "framer-motion";
import popup from '../../assets/Home/Popup.jpg'

const Popup = () => {
  const [open, setOpen] = useState(false);

  useEffect(() => {
    const timer = setTimeout(() => {
      setOpen(true);
    }, 3000); 

    return () => clearTimeout(timer);
  }, []);

  return (
    <Dialog
      open={open}
      onClose={() => setOpen(false)}
      PaperProps={{
        component: motion.div,
        initial: { y: -100, opacity: 0 },
        animate: { y: 0, opacity: 1 },
        exit: { y: -100, opacity: 0 },
        transition: { duration: 0.5, ease: "easeOut" },
        style: { borderRadius: 10, position: "relative" },
      }}
    >
      {/* Close Icon Button */}
      <IconButton
        onClick={() => setOpen(false)}
        sx={{
          position: "absolute",
          top: 8,
          right: 8,
          color: "black",
        }}
      >
        <CloseIcon />
      </IconButton>

      <DialogContent>
        <img
          src={popup}
          alt="Popup"
          style={{ width: "100%" }}
        />
      </DialogContent>
    </Dialog>
  );
};

export default Popup;
