import React from "react";

import { storage } from "../../services/apiservices";



const VerticalSlider = ({events}) => {
  return (
    <div 
    className="slider-wrapper justify-content-end"
    data-aos="fade-uo"
    data-aos-delay="200"
  >
    {/* First Slider - Moves Up */}
    <div 
      className="slider-container-vertical red-slider"
 
    >
      <div className="slider-vertical scroll-up">
        {events.concat(events).map((img, index) => (
          <div 
            key={`up-${index}`} 
            className="slide-vertical"
            data-aos="zoom-in"
            data-aos-delay={400 + (index % events.length * 50)}
          >
            <img 
              src={`${storage}/${img.image_path}`} 
              alt={`Event ${img.title || index}`} 
              className="img-fluid" 
              loading="lazy"
            />
          </div>
        ))}
      </div>
    </div>

    {/* Second Slider - Moves Down */}
    <div 
      className="slider-container-vertical"

    >
      <div className="slider-vertical scroll-down">
        {events.concat(events).map((img, index) => (
          <div 
            key={`down-${index}`} 
            className="slide-vertical"

          >
            <img 
              src={`${storage}/${img.image_path}`} 
              alt={`Event ${img.title || index}`} 
              className="img-fluid" 
              loading="lazy"
            />
          </div>
        ))}
      </div>
    </div>

    {/* Third Slider - Moves Up */}
    <div 
      className="slider-container-vertical red-slider"

    >
      <div className="slider-vertical scroll-up">
        {events.concat(events).map((img, index) => (
          <div 
            key={`up2-${index}`} 
            className="slide-vertical"
   
          >
            <img 
              src={`${storage}/${img.image_path}`} 
              alt={`Event ${img.title || index}`} 
              className="img-fluid" 
              loading="lazy"
            />
          </div>
        ))}
      </div>
    </div>
  </div>
  );
};

export default VerticalSlider;
