import React, { createContext, useState, useEffect, useMemo, useCallback } from "react";
import apiService from "../services/apiservices";
import Loader from "../components/Loader";

export const Themecontext = createContext();

const ThemeProvider = ({ children }) => {
  const [show, setShow] = useState(false);
  const [showLoader, setShowLoader] = useState(true);
  const [lazyloading, setLazyLoading] = useState(true);
  const [showPopup, setShowPopup] = useState(false);
  const [events, setEvents] = useState([]);
  const [banner, setBanner] = useState([]);
  const [brochures, setBrochure] = useState([]);
  const [awards, setAwards] = useState([]);
  const [arivukeni, setArivukeni] = useState([]);

  // Memoized handlers to prevent unnecessary re-renders
  const handleClose = useCallback(() => setShow(false), []);
  const handleShow = useCallback(() => setShow(true), []);

  useEffect(() => {
    const fetchData = async () => {
      try {
        const [
          responseEvents,
          responseBanner,
          responseBrochure,
          responseAwards,
          responseArivukeni
        ] = await Promise.all([
          apiService.get("galleries"),
          apiService.get("banners"),
          apiService.get("brouchers"),
          apiService.get("awards"),
          apiService.get("arivukkeni")
        ]);

        setEvents(responseEvents.data);
        setBanner(responseBanner.data);
        setBrochure(responseBrochure.data);
        setAwards(responseAwards.data);
        setArivukeni(responseArivukeni.data);
      } catch (error) {
        console.error("Error fetching data:", error);
      } finally {
        setLazyLoading(false); 
      }
    };

    fetchData();
  }, []);

  // Memoize the context value to prevent unnecessary re-renders
  const contextValue = useMemo(() => ({
    setShow,
    show,
    handleClose,
    handleShow,
    setShowLoader,
    showLoader,
    showPopup,
    setShowPopup,
    events,
    banner,
    brochures,
    awards,
    arivukeni,
  }), [
    show, 
    showLoader, 
    showPopup, 
    events, 
    banner, 
    brochures, 
    awards, 
    arivukeni,
    handleClose,
    handleShow
  ]);

  return (
    <Themecontext.Provider value={contextValue}>
      {lazyloading ? <Loader /> : children} 
    </Themecontext.Provider>
  );
};

export default ThemeProvider;