import React, { useState, useEffect } from "react";
import { Link } from "react-router-dom";
import { Container, Row, Col, Nav } from "react-bootstrap";
import { FaFacebook, FaInstagram, FaLinkedin } from "react-icons/fa";
import cd from "../assets/cd.svg";
import { IoIosArrowForward } from "react-icons/io";
import apiService from "../services/apiservices";

const Footer = () => {
  const [logo, setLogo] = useState("");

  useEffect(() => {
    const fetchLogo = async () => {
      try {
        const response = await apiService.get("users");
        if (response.status === "success" && response.data.length > 0) {
          const profileUrl = response.data[0].profile_url.replace(
            "profiles/",
            ""
          );
          setLogo(
            `https://www.cbf.codissia.com/backend/public/profiles/${profileUrl}`
          );
        }
      } catch (error) {
        console.error("Failed to fetch logo:", error);
      }
    };
    fetchLogo();
  }, []);

  return (
    <div>
      <footer className="footer  text-dark ">
        <Container className="footer-main">
          <Row className="text-center text-md-start">
                  <Col md={6} lg={3}  className="mb-3">
              <div className="d-flex justify-content-center flex-column">
                <div className="mb-3">
                <Link to="/">
                  {logo ? (
                    <img className="img-fluid logo-img" src={logo} alt="Logo" />
                  ) : (
                    <p>Loading logo...</p>
                  )}
                </Link>
                </div>
             
                <div className="d-flex justify-content-center">
                  <div className="event-heading ">
                    <div className="text-center event-date">
                      <h4>18ᵗʰ - 27ᵗʰ July 2025</h4>
                      <h6>
                      கொடிசியா தொழில்காட்சி வளாகம், கோயம்புத்தூர்,
                        தமிழ்நாடு, இந்தியா
                      </h6>
                    </div>
                  </div>
                </div>
              </div>
            </Col>
                  <Col md={6} lg={3}  className="mb-3">
              <h5>விரைவு இணைப்புகள்</h5>
              <ul className="list-unstyled">
                <Nav.Link>
                  <Link to="/"> <IoIosArrowForward /> முகப்பு </Link>
                </Nav.Link>
                <Nav.Link>
                  <Link to="/விருதுகள்"> <IoIosArrowForward /> விருதுகள்</Link>
                </Nav.Link>
                <Nav.Link>
                  <Link to="/இலக்கியக்கூடல்"> <IoIosArrowForward />இலக்கியக்கூடல்</Link>
                </Nav.Link>
                <Nav.Link>
                  <Link to="/அறிவுக்கேணி"> <IoIosArrowForward />அறிவுக்கேணி </Link>
                </Nav.Link>
                <Nav.Link>
                  <Link to="/நிகழ்வுகள்"> <IoIosArrowForward />நிகழ்வுகள்</Link>
                </Nav.Link>

                <Nav.Link>
                  <Link to="/தொடர்புக்கு"> <IoIosArrowForward />தொடர்புக்கு</Link>
                </Nav.Link>
              </ul>
            </Col>
                  <Col md={6} lg={3}  className="mb-3">
              <h5>அலுவலகம்</h5>
              <p className="">
              கொடிசியா தொழில்காட்சி வளாகம், ஜி.டி நாயுடு டவர்ஸ், அவிநாசி சாலை, கோயம்புத்தூர்
              </p>
              <div className=" footer-contact-info">
                <a href="mailto:cbf@codissia.com">cbf@codissia.com</a>
                <hr />
                <a href="tel:+918870506333">+91 88705 06333</a>
              </div>
            </Col>
            <Col md={3} className="mb-3 text-center ">
              <h5>எங்களைப் பின்தொடருங்கள்</h5>
              <div className="social-icons">
                <a href="#" className="me-3">
                  <FaFacebook />
                </a>

                <a href="#" className="me-3">
                  <FaInstagram />
                </a>
                <a href="#">
                  <FaLinkedin />
                </a>
              </div>
              <div className="footer-info">கோயம்புத்தூர் புத்தகத் திருவிழா</div>
            </Col>
          </Row>
        </Container>
      </footer>
      <div className="footer-bottom text-center ">
        <Container>
          <Row className=" footer-main">
            <Col className="text-center text-dark d-flex justify-content-center align-items-center">
              <p className="mb-0 footer-info">
                © {new Date().getFullYear()} - Codissia. All Rights Reserved{" "}
              </p>
            </Col>
            <Col className="text-center text-dark ">
              <p className="mb-0 footer-info">
                Website designed and developed by
                <a href="https://www.clouddreams.in/" target="_blank">
                  <img src={cd} alt="" srcset="" />{" "}
                </a>
              </p>
            </Col>
          </Row>
        </Container>
      </div>
    </div>
  );
};

export default Footer;
