import React, { useState, useEffect, useMemo } from "react";
import { Link } from "react-router-dom";
import TamilNavbar from "./Navbar";
import apiService from "../services/apiservices";

const Header = () => {
  const [logo, setLogo] = useState("");
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);

  const eventDetails = useMemo(() => ({
    date: "18ᵗʰ - 27ᵗʰ July 2025",
    location1: "கொடிசியா தொழில்காட்சி வளாகம்,",
    location2: "கோயம்புத்தூர்"
  }), []);

  useEffect(() => {
    let isMounted = true;
    
    const fetchLogo = async () => {
      try {
        const response = await apiService.get("users");
        if (isMounted) {
          if (response.status === "success" && response.data.length > 0) {
            const profileUrl = response.data[0].profile_url.replace("profiles/", "");
            setLogo(`https://www.cbf.codissia.com/backend/public/profiles/${profileUrl}`);
          }
          setLoading(false);
        }
      } catch (error) {
        if (isMounted) {
          console.error("Failed to fetch logo:", error);
          setError("Failed to load logo");
          setLoading(false);
        }
      }
    };

    fetchLogo();

    return () => {
      isMounted = false;
    };
  }, []);

  const renderLogo = useMemo(() => {
    if (loading) return <p>Loading logo...</p>;
    if (error) return <p>{error}</p>;
    return logo ? (
      <img 
        className="img-fluid logo-img" 
        src={logo} 
        alt="Logo" 
        loading="lazy"
      />
    ) : null;
  }, [logo, loading, error]);

  return (
    <div>
      <section className="header_logo_bg">
        <div className="pe-2 ps-3 d-none d-lg-block">
          <div className="container-fluid">
            <div className="d-flex justify-content-center align-items-center logo-main">
              <div>
                <Link to="/">
                  {renderLogo}
                </Link>
              </div>
              <div className="event-heading">
                <div className="text-center event-date">
                  <h4>{eventDetails.date}</h4>
                  <h5>{eventDetails.location1}</h5>
                  <h5>{eventDetails.location2}</h5>
                </div>
              </div>
            </div>
          </div>
        </div>
        <TamilNavbar />
      </section>
    </div>
  );
};

export default React.memo(Header);